/* This is the main function for the Prospero program vcache.
   Exit with status 0 if file retrieval was successful; nonzero if it was not. 
   This is called only by pmap_cache(), in lib/pcompat/pmap_cache.c and by
   VGET in user/vget.c
*/

/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/socket.h>

#include "ftp_var.h"

#include <pfs.h>
#include <pcompat.h>

/* Benjamin Britt wrote routines enabling VCACHE to retrieve files 
   using WAIS.  These are not yet very useful, since modifications
   need to be made to user/vget.c and lib/pfs/pget_am.c.  Therefore, they are
   commented out.  #define WAIS and change the definitions of WAIS_LIBS and
   WAIS_TARGETS in the Makefile in order to link them in, if you wish to
   experiment with them and continue developing them.  You will also need the
   directory user/vcache/wais, which is not part of the standard distribution,
   but will be sent on request.

   #define WAIS
*/

int		pfs_debug = 0;
int		cache_verbose = 0;
int		pfs_enable = PMAP_DISABLE;

main(argc, argv)
    int	argc;
    char *argv[];
{
    int	manage_cache = 0;
    int	replace = 0;
    int	flush = 0;
    int	retval = 0;

    char	*host;          /* remote host */
    char	*remote;        /* remote filename */
    char	*local;         /* local filename */
    char	*method;

    char	cachedir[MAXPATHLEN];
    char	*slash;

    debug = 0;
    verbose = 0;
    trace = 0;

    argc--;argv++;

    while (argc > 0 && *argv[0] == '-') {
        switch (*(argv[0]+1)) {

        case 'D':
            pfs_debug = 1; /* Default debug level */
            sscanf(argv[0],"-D%d",&pfs_debug);
            options |= SO_DEBUG;
            debug++;
            break;

        case 'f':
            flush = 1;
            break;

        case 'm':
            manage_cache = 1;
            break;

        case 'r':
            replace = 1;
            break;

        case 't':     /* FTP Trace */
            trace++;
            break;

        case 'v':
            cache_verbose = 1;
            verbose = 1;
            break;

        case '\0':              /* Ignore the dummy flag "-".  This lets us
                                   specify flags easily to execl(). */
            break;

        default:
            fprintf(stderr,
                  "Usage: vcache [-fmrv] local access-method-name hosttype \
host nametype name [additional args...]\n");
            exit(1);
        }
        argc--; argv++;
    }
    if((argc == 1) && flush) {
        host = NULL;
        remote = NULL;
        local = argv[0]; argc--; argv++;
        method = NULL;
    }
    else if((argc == 0) && flush) {
        host = NULL;
        remote = NULL;
        local = NULL;
        method = NULL;
    }
    else if(argc >= 6) {
        local = argv[0]; argc--; argv++;
        method = argv[0]; argc--; argv++;
        argc--, argv++;         /* hosttype always INTERNET-D for now. */
        host = argv[0]; argc--; argv++;
        argc--, argv++;         /* filetype always ASCII for now. */
        remote = argv[0]; argc--; argv++;
    }
    else {
        fprintf(stderr, "Usage: vcache [-fmrv] local access-method-tuple\n");

        exit(1);
    }

    /* Add code here to manage the cache */

    /* If no method provided, then we are done */
    if(!method) exit(0);

    /* Make the directory to include the cached copy */
    /* if it does not already exist                  */
    strcpy(cachedir,local);
    slash = rindex(cachedir,'/');
    if(slash) {
        *slash = '\0';
        retval = mkdirs(cachedir);
        if(retval && verbose) perror("Can't create local directory");
        if(retval) exit(1);
    }

    anonlogin = strequal(method,"AFTP");
    if(anonlogin || strcmp(method,"FTP") == 0) {
        char	*trans_mode;
        if(argc != 1) {
            fprintf(stderr,"vcache: wrong number of arguments for %s\n",
                    method);
            exit(1);
        }
        trans_mode = argv[0];
        if(strcmp(trans_mode,"DIRECTORY") == 0) {
            fprintf(stderr,"File is the directory %s on the host %s.\n",
                    remote,host);
            fprintf(stderr,"%s may not be running Prospero.\n",host);
            exit(1);
        }
        retval = aftpget(host,local,remote,trans_mode);
        if(retval) exit(1);
        else exit(0);
    } else if (strcmp(method, "GOPHER") == 0) {
        extern char *index();
        /* Remote file name is Gopher selector string. */
        /* port # included in the hostname. */
        /* Check validity of the argument. */
        register char *cp = index(host, '(');

        if (cp == NULL) {
            if (cache_verbose)
                fprintf(stderr, "vcache: The GOPHER access method requires \
that the specified hostname have a port number included.  Got the hostname \
%s.\n", host);
            exit(1);
        }
        *cp++ = '\0';             /* terminate the hostname normally. 
                                     cp now points to the port start. */
        if (argc != 0) {
            if (cache_verbose)
                fprintf(stderr, "vcache: The GOPHER access method expects \
no additional arguments.  Got %d arguments.\n", argc);
            exit(1);
        }
        
        if(retval = gopherget(host,local,remote,atoi(cp)))
            exit(1);
        else
            exit(0);
#ifdef WAIS
    } if (strcmp(method,"WAIS") == 0) {

        /* Note that the remote file name is actually the docid */

        retval = WAISRetrieve(local, host, remote, argv[0]);
        if (retval) exit(1);
        else exit(0);
#endif
    } else {
       fprintf(stderr,"vcache: access method (%s) not supported\n",method);
       exit(1);
    }
    /* NOTREACHED */
}
