/* Copyright (c) 1992, 1993 by the University of Southern California
 * For copying and distribution information, please see the file
 * <usc-copyr.h>
 */

#include <usc-copyr.h>
#include <pfs.h>
#include <pparse.h>
#include <psrv.h>
#include <stdio.h>
#include <perrno.h>
#include <plog.h>
#ifndef MAXPATHLEN
#include <sys/param.h>
#include <sys/stat.h>
#endif

extern char *rindex();

extern char	shadow[];
extern char	dirshadow[];
extern char	dircont[];
extern char	pfsdat[];
extern char	aftpdir[];

#define FILE_VNO            5   /* version # of the file format.   Appears in
                                   this file and in dsrfinfo.c */

/* Logs errors to plog() and returns an error code. */
int 
dswfinfo(char *nm, PFILE fi)
{
    static FILE *open_shadow_outfile(char nm[]);
    static int write_data(FILE * outf, PFILE fi);
    int     retval;

    FILE *outf;
    if (outf = open_shadow_outfile(nm)) {
        retval = write_data(outf, fi);
    } else {
        return perrno;
    }
    fclose(outf);
    return retval;
}
    

static FILE *
open_shadow_outfile(char nm[])
{
    char        real_fname[MAXPATHLEN];     /* Filename after expansion  */
    char	shadow_fname[MAXPATHLEN];   /* max. length unix filename */ 
    char	shadow_dirname[MAXPATHLEN]; /* directory we create.      */
    char        *sp;                        /* pointer to slash          */
    FILE        *outf;
    
    struct stat	file_stat_dat;
    struct stat	*file_stat = &file_stat_dat;

    /* If special file name, change to real file name */
    if((*nm != '/') && *aftpdir && (strncmp(nm,"AFTP",4) == 0)) {
	strcpy(real_fname,aftpdir);
	strcat(real_fname,nm+4);
    }
    else strcpy(real_fname,nm);
    
    /* Create the directory to contain the shadow file, if it doesn't already
       exist. */  
    /* Is the shadow file a directory? */
    if (stat(real_fname, file_stat) == 0) {
        if(file_stat->st_mode & S_IFDIR)  {
            qsprintf(shadow_fname, sizeof shadow_fname, 
                     "%s%s/%s", shadow, real_fname, dirshadow);
        } else {
            qsprintf(shadow_fname, sizeof shadow_fname,
                     "%s%s", shadow, real_fname);
        }
    }
    strcpy(shadow_dirname, shadow_fname);
    assert(sp = rindex(shadow_dirname, '/')); /* must be true. */
    *sp = '\0';
    mkdirs(shadow_dirname);
    if ((outf = fopen(shadow_fname, "w")) == NULL) {
        plog(L_DATA_FRM_ERR, NOREQ, "Couldn't open the output data file %s", 
             shadow_fname);
        perrno = PFAILURE;
    }
    return outf;
}


static int
write_data(FILE * outf, PFILE fi)
{
    OUTPUT_ST out_st;
    OUTPUT out = &out_st;
    PATTRIB at;

    filetoout(outf, out);
    qoprintf(out, "VERSION %d\n", FILE_VNO);
    qoprintf(out, "MAGIC-NUMBER %d\n", fi->f_magic_no);
    for (at = fi->attributes; at; at = at->next) {
        if (at->nature != ATR_NATURE_INTRINSIC) /* INTRINSIC attributes are 
                                              written specially  */
            out_atr(out, at, 0);
    }
    return PSUCCESS;
}
