/* Checks Kerberos authentication, and returns authenticated client name.
   Returns non-zero on error. */

/* Copyright (c) 1992 by the University of Southern California.
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 */
/* Author: Prasad Upasani (prasad@isi.edu)
 * Modifications by swa@isi.edu.
 */


#include <psite.h>              /* must precede pfs.h for KERBEROS 
                                 compilation option. */
#include <pfs.h>
#ifdef KERBEROS                 /* Only compile this file if we are using
                                   Kerberos, since it refers to files in the
                                   Kerberos libraries. */
/* Note that this is currently actually used only by the server.  It is in
   libpfs instead of libpsrv because the clients will eventually need it for
   mutual authentication. */

#include <stdio.h>
#include <krb5/krb5.h>
#include <netinet/in.h>


int
check_krb_auth(auth, client, ret_client_name)
     char *auth;
     struct sockaddr_in client;
     char *ret_client_name;     /* Stores the name to be returned. */
{
    krb5_data inbuf;
    krb5_principal server;
    krb5_address *sender_addr;
    char service_name[255], hostname[255];
    int retval;
    krb5_address client_addr;
    krb5_tkt_authent *authdat;
    char *client_name;

    /* Create a server principal structure. */
    if (retval = gethostname(hostname, sizeof(hostname)))
      return(retval);

    strcpy(service_name, KERBEROS_SERVICE);
    strcat(service_name, "/");
    strcat(service_name, hostname);
    
    if (retval = krb5_parse_name(service_name, &server))
      return(retval);

    /* Put auth data into a krb5_data structure. */
    inbuf.data = stalloc(AUTHENTICATOR_SZ);
    retval = bindecode(auth, inbuf.data, AUTHENTICATOR_SZ);
    if (retval < 0 || retval >= AUTHENTICATOR_SZ)
      return(retval);
    inbuf.length = retval;

    /* Put client address in a krb5_address structure. */
    client_addr.addrtype = client.sin_family;
    client_addr.length = sizeof(client.sin_addr);
    client_addr.contents = (krb5_octet *) &client.sin_addr;

    /* Check authentication. */
    retval = krb5_rd_req(&inbuf,
			     server,
			     &client_addr,
			     "FILE:/nfs/pfs/prospero.build/prasad/atg.isi.edu-srvtab",
			     0, 0, 0, /* This may have to be changed */
                         &authdat);
    stfree(inbuf.data);
    if (retval)
        return retval;          /* Authentication failed. */
    /* Get client name. */
    if (retval = krb5_unparse_name(authdat->authenticator->client, 
				   &client_name))
      return(retval);
  
    strcpy(ret_client_name, client_name);
    return 0;
}

    
#endif /*KERBEROS */
