/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <strings.h>
#include <netdb.h>

#include <pfs.h>
#include <psite.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

static char	*myvhostname = 0;
char		*myhostname();

/*
 * see pcompat.h for the meanings of the flags
 */
/* This function looks a heck of a lot like retrieve_link() in user/vget.c.  If
   there's a bug here, there's one there too. */
mapname(link,npath, npathlen, readonly)
    VLINK	link;
    char	*npath;         /* local pathname for file you can work with.
                                   */ 
    int         npathlen;
    int		readonly;
{

    TOKEN           am_args; /* filled in by pget_am */
    int		am;
    int		tmp;
    int		methods = P_AM_LOCAL; /* local filenames always are supported.
                                         */ 

    /* First time called, find out hostname and remember it */
    if(!myvhostname) myvhostname = myhostname();

#ifdef P_NFS
    methods |= P_AM_NFS;
#endif P_NFS

#ifdef P_AFS
    methods |= P_AM_AFS;
#endif P_AFS

#ifdef PCOMPAT_SUPPORT_FTP
    if (readonly) methods |= P_AM_FTP;
#endif

    /* P_AM_FTP requires prompting for a password, which is not something
       transparent to the user.  That's why P_AM_FTP is not supported
       by mapname. */
    if(readonly) methods |= P_AM_AFTP | P_AM_GOPHER | P_AM_RCP;

    am = pget_am(link,&am_args,methods);

    if(!am && perrno) {
        return(perrno);
    }

    switch(am) {

#ifdef P_NFS
    case P_AM_NFS: 
        /* XXX You must change pmap_nfs() to meet the needs of your site. */
        tmp = pmap_nfs(link->host,link->hsoname,npath, npathlen, am_args);
        return(tmp);
#endif P_NFS

#ifdef P_AFS
    case P_AM_AFS: 
        strcpy(npath,P_AFS);
        strcat(npath,elt(am_args,4)); /* 4th element is the hsoname. */
        return(PSUCCESS);
#endif P_AFS

    case P_AM_AFTP: 
#ifdef PCOMPAT_SUPPORT_FTP
    case P_AM_FTP: 
#endif
    case P_AM_GOPHER: 

        tmp = pmap_cache(link, npath, npathlen, am_args);
        return(tmp);

    case P_AM_LOCAL:
        strcpy(npath, elt(am_args, 4));
        return PSUCCESS;

    default:
        return(PFSA_AM_NOT_SUPPORTED);
    }
}


