/* Author: bcn@isi.edu */
/* Updated & modified by swa@isi.edu */
/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <netdb.h>
#include <sgtty.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>

#include <ardp.h>
#include <pserver.h>
#include <pfs.h>
#include <pparse.h>
#include <psrv.h>
#include <plog.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

#include "dirsrv.h"


/* Right now, the only attribute we publish for OBJECTs is ACCESS-METHOD.  This
   will eventually change.  But not soon. */

int
get_object_info(RREQ req, char *command, char *next_word, INPUT in)
{
    VLINK	check_fwd();
    int tmp;

    optdecl;
    char 	t_requested[MAX_DIR_LINESIZE]; /* attributes requested */
    char 	t_ntype[MAX_DIR_LINESIZE]; /* handle type */
    char 	t_fname[MAX_DIR_LINESIZE]; /* obj handle */
    long	        t_num = 0;          /* Magic #. */
    VLINK		clink;            /* For stepping through links   */
    int		item_count = 0;    /* Count of returned items     */
    PFILE		fi;                /* individual lines            */
    int		rsinfo_ret;       /* Ret Val from dsrfinfo        */
    TOKEN           nfs_am;     /* Access method for NFS (if any) */
    char		*suffix;	  /* Trailing component(s)        */
    int                 all = 0; /* List all attributes? */
    OUTPUT_ST           out_st;
    OUTPUT              out = &out_st;

    reqtoout(req, out);
    /* still have to read the remainder of the attributes */
    tmp = qsscanf(next_word,"%'s %s %'s %*d %r",
                 t_requested,t_ntype,t_fname,&next_word);
    /* Log and return a better message */
    if(tmp != 3) {
        creply(req,"ERROR wrong number of arguments\n");
        plog(L_DIR_PERR,req,"Wrong # of arguments: %s", command, 0);
        return PFAILURE;
    }
    if(in_select(in, &t_num))
        return error_reply(req, "GET-OBJECT-INFO %'s", p_err_string);
    /* Do we need a better log message */
    plog(L_DIR_REQUEST, req, "GOI %s %s", t_requested,t_fname,0);

    if(check_handle(t_fname) == FALSE) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR, req,"Invalid object name: %s",t_fname,0);
        return PFAILURE;
    }

    optstart(t_requested);
    all = opttest("#ALL") || opttest("#OBJECT") || opttest("#INTERESTING") ||
        opttest("#FIELD") || opttest("#APPLICATION");
    
    clink = vlalloc();
    if (!clink) out_of_memory();
    fi = pfalloc();
    if (!fi) out_of_memory();

    clink->hsonametype = stcopyr(t_ntype,clink->hsonametype);
    clink->hsoname = stcopyr(t_fname,clink->hsoname);
    clink->f_magic_no = t_num;

    rsinfo_ret = dsrfinfo(clink->hsoname,clink->f_magic_no,fi);

    if(all || opttest("FORWARDING-POINTER")) {
        if(rsinfo_ret == DSRFINFO_FORWARDED) {
            VLINK fl;           /* List of forwarding pointers. */
            if(fl = check_fwd(fi->forward,clink->hsoname,
                              clink->f_magic_no)) {
                replyf(req,"ATTRIBUTE OBJECT INTRINSIC FORWARDING-POINTER LINK\
 L FP %'s %s %'s %s %'s %d %d\n",
                       clink->name,
                       fl->hosttype, fl->host,
                       fl->hsonametype, fl->hsoname,
                       fl->version,fl->f_magic_no,0);
                item_count++;
            }
        } else if((clink->f_magic_no == 0) && (fi->f_magic_no != 0)) {
            replyf(req,"ATTRIBUTE OBJECT INTRINSIC FORWARDING-POINTER LINK L \
FP %'s %s %s %s %'s %d %d\n",
                   clink->name,
                   clink->hosttype, hostwport,
                   clink->hsonametype, clink->hsoname,
                   clink->version,fi->f_magic_no,0);
            item_count++;
        }
    } else if(rsinfo_ret == DSRFINFO_FORWARDED) {
        VLINK fl;               /* List of forwarding pointers */
        VLINK fp;               /* Current forwarding pointer */
        fl = fi->forward; fi->forward = NULL;
        fp = check_fwd(fl,clink->hsoname,clink->f_magic_no);

        /* Free what we don't need */
        pffree(fi); fi = NULL;

        /* Got to location to return forwarded error */
        forwarded(req, fl, fp, clink->hsoname);
        vlfree(clink);
        return PSUCCESS;
    }
    if(all || opttest("ACCESS-METHOD")) {
        if (myaddress() == req->peer_addr.s_addr ||
            /* Check for loopback net.  */
#if BYTE_ORDER == BIG_ENDIAN
            (req->peer_addr.s_addr & 0xff000000) == (127 << 24)
#else
            (req->peer_addr.s_addr & 0x000000ff) == 127
#endif
            ) {
            /* This may not return information for multi-homed hosts.
               But it will never return incorrect information.  */
#ifdef REALLY_NEW_FIELD
            reply(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE \
LOCAL '' '' '' ''\n");
#else
            reply(req, 
                  "ATTRIBUTE OBJECT FIELD ACCESS-METHOD LOCAL '' '' '' ''\n");
#endif
            item_count++;
        } else {
#ifdef SHARED_PREFIXES
            char *cp;      /* this memory doesn't need to be freed. */
            if (cp = check_localpath(t_fname, req->peer_addr.s_addr)){
#ifdef REALLY_NEW_FIELD
                replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD LOCAL \
'' '' '' %s\n", cp);
#else
                replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE \
LOCAL '' '' '' %s\n", cp);
#endif
                item_count++;
            }
#endif            
        }
#ifdef NFS_EXPORT
        if(nfs_am = check_nfs(t_fname,req->peer_addr.s_addr)) {
            reply(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD ");
#ifdef REALLY_NEW_FIELD
            reply(req, "SEQUENCE ");
#endif
            out_sequence(out, nfs_am);
            tklfree(nfs_am);
            item_count++;
        }
#endif NFS_EXPORT

        if(*afsdir && (sindex(clink->hsoname,afsdir) == 
                       clink->hsoname)) {
            suffix = clink->hsoname + strlen(afsdir);
            /* AFS method: hostname is irrelevant. */
#ifdef REALLY_NEW_FIELD
            replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD AFS '' '' ASCII \
%'s\n", suffix);
#ifdef AFS_AFTP_GATEWAY
            replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD AFTP INTERNET-D \
%s ASCII %'s%'s BINARY\n", hostname, AFS_AFTP_GATEWAY, suffix);
#endif
#else
            replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE AFS \
'' '' ASCII %'s\n", suffix);
#ifdef AFS_AFTP_GATEWAY
            replyf(req, "ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE \
AFTP INTERNET-D %s ASCII %'s%'s BINARY\n", hostname, AFS_AFTP_GATEWAY, suffix);
#endif
#endif
            item_count++;
        }

        /* Find the real name of the file and use it */
        /* To check for AFTP access                  */
/*		    rnl = readlink(clink->hsoname,rname,MAXPATHLEN); */
/* 		    if(rnl >= 0) *(rname+rnl) = '\0';                 */

        if(*aftpdir && (sindex(clink->hsoname,aftpdir) == 
                        clink->hsoname)) {
            suffix = clink->hsoname + strlen(aftpdir);
#ifdef REALLY_NEW_FIELD
            replyf(req,"ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE \
AFTP INTERNET-D %'s ASCII %'s BINARY\n", hostname, suffix);
#else
            replyf(req,"ATTRIBUTE OBJECT FIELD ACCESS-METHOD AFTP INTERNET-D \
%'s ASCII %'s BINARY\n", hostname, suffix);
#endif
	    item_count++;
        }
        else if(*aftpdir && (sindex(clink->hsoname,"AFTP") == 
                        clink->hsoname)) {
            suffix = clink->hsoname + 4;
#ifdef REALLY_NEW_FIELD
            replyf(req,"ATTRIBUTE OBJECT FIELD ACCESS-METHOD SEQUENCE \
AFTP INTERNET-D %'s ASCII %'s BINARY\n", hostname, suffix);
#else
            replyf(req,"ATTRIBUTE OBJECT FIELD ACCESS-METHOD AFTP INTERNET-D \
%'s ASCII %'s BINARY\n", hostname, suffix);
#endif
	    item_count++;
        }
    } 
    /* Here we must check the file info, look for matching */
    /* attributes and return them                          */
    if(rsinfo_ret <= 0) {
        PATTRIB ca = fi->attributes;
        while(ca) {
            if(all || opttest(ca->aname)) {
                out_atr(out, ca, 0);
                item_count++;
            }
            ca = ca->next;
        }
    }
    /* If none match, say so */
    if(!item_count)
        reply(req,"NONE-FOUND\n");

    pffree(fi); fi = NULL;
    vlfree(clink);
    return PSUCCESS;
}
