/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>

#include <ardp.h>
#include <pfs.h>
#include <pparse.h>
#include <plog.h>
#include <psrv.h>
#include <perrno.h>
#include <pmachine.h>

#include "dirsrv.h"

static 
int
srv_vl_delete(VLINK *linksp, VLINK link);

delete_link(RREQ req, char *command, char *next_word, INPUT in,
            char client_dir[], int dir_magic_no)
{
    char 	t_name[ARDP_PTXT_LEN_R];
    char 	t_options[ARDP_PTXT_LEN_R];
    long        t_magic_no = 0;  /* 0 means none specified.     */
    int         retval;
    ACL		wacl;		 /* Working access control list */
    int         tmp;             /* return value from qsscanf() */
    char        *cp;             /* dummy pointer               */
    VLINK       reglink = NULL;  /* target regular link         */
    VLINK       ulink = NULL;    /* target union link           */
    VDIR_ST	dir_st;          /* Directory contents used ... */
    VDIR	dir = &dir_st;   /* by individual lines         */

    vdir_init(dir);

    tmp = qsscanf(next_word,"%'s %'s %r", t_options, t_name, &cp);

    /* Log and return a better message */
    if (tmp < 0)
        return error_reply(req, "Format error: %'s", command, 0);
    if(tmp < 2)
        return error_reply(req, "Too few arguments: %'s", command, 0);
    if (tmp > 2)
        return error_reply(req, "Too many arguments: %'s", command, 0);

    if(retval = in_select(in, &t_magic_no))
        return error_reply(req, "DELETE-LINK: %'s", p_err_string);

    if (!strequal(t_options, ""))
        return error_reply(req, "DELETE-LINK: options must be empty: %'s",
                           command);
#if 0
    if (!strequal(t_options, "VLINK") && !strequal(t_options, "ULINK") 
        && !strequal(t_options, "LINK"))
        return error_reply(req, "DELETE-LINK: option must be exactly one of \
VLINK, LINK, or ULINK.");
#endif
    
    /* Do we need a better log message */
    plog(L_DIR_UPDATE,req,"RM %s %s ID REMOTE %ld",
         client_dir,t_name,t_magic_no,0);

    retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
    if(retval == DSRFINFO_FORWARDED) 
        return dforwarded(req, client_dir, dir_magic_no, dir);

    /* If not a directory, say so */
    if(retval == DSRDIR_NOT_A_DIRECTORY) {
        creply(req,"FAILURE NOT-A-DIRECTORY\n");
        plog(L_DIR_ERR, req,"Invalid directory name: %s", client_dir,0);
        return PFAILURE;
    }

    /* Need to find the link so we can check its ACL */
    if (t_options[0] == 'U')
        reglink = NULL;
    else
        reglink = dir->links;
    while(reglink) {
        if(strequal(reglink->name,t_name))
            if ((t_magic_no == 0) || (t_magic_no == reglink->f_magic_no))
                break;
        reglink = reglink->next;
    }
    if(!reglink && (t_options[0] != 'L')) {
        ulink = dir->ulinks;
        while(ulink) {
            if(strequal(ulink->name,t_name)) 
                if ((t_magic_no == 0) || (t_magic_no == reglink->f_magic_no))
                    break;
            ulink = ulink->next;
        }		 
    }
    if (reglink) 
        wacl = reglink->acl;
    else if (ulink)
        wacl = ulink->acl;
    else
        wacl = NULL;

    /* If not authorized, say so */
    if(!check_acl(dir->dacl,wacl, req,"d")) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR,req,"Unauthorized DELETE-LINK: %s %s",client_dir,
             t_name); 
        vdir_freelinks(dir);
        return PFAILURE;
    }
    if ((reglink && reglink->linktype == 'N') ||
        (ulink && ulink->linktype == 'N')) {
        creplyf(req, "FAILURE SERVER-FAILED Deleting NATIVE links is not \
implemented.  Reset this directory''''s INCLUDE-NATIVE attribute to \
NONATIVE and retry the operation.");
        plog(L_FAILURE, req, "Tried to DELETE-LINK on NATIVE link: %s %s",
             client_dir, t_name);
        vdir_freelinks(dir);
        return PFAILURE;
    }

    if (reglink) 
        assert(srv_vl_delete(&(dir->links), reglink) == PSUCCESS);
    else if (ulink)
        assert(srv_vl_delete(&(dir->ulinks), ulink) == PSUCCESS);
    else {
        creplyf(req,"FAILURE NOT-FOUND FILE %'s\n",t_name);
        plog(L_DIR_ERR,req,"Link not found: %s %s",
             client_dir, t_name,0);
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }
    
    retval = dswdir(client_dir,dir);
    vdir_freelinks(dir);
    /* if successful say so (need to clean this up) 
       XXX How should we clean this up?  Looks OK to me. --swa*/
    if(!retval) {
        reply(req,"SUCCESS\n");
        return PSUCCESS;
    } else {
        creply(req,"FAILURE\n");
        return retval;
    }
}

static  int srv_vl_delete(VLINK *linksp, VLINK link)
{
    EXTRACT_ITEM(link, (*linksp));
    vlfree(link);
    return PSUCCESS;
}
