/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

/* Seriously mutilated by swa@isi.edu, 9/29/92 -- 9/30/92 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <ardp.h>
#include <pfs.h>
#include <plog.h>
#include <psrv.h>
#include <perrno.h>
#include <pprot.h>
#include <pmachine.h>
#include "dirsrv.h"

/* list_acl.c */

extern char	*acltypes[];

int 
list_acl(RREQ req, char * command, char *next_word, INPUT in, 
         char client_dir[], int dir_magic_no)
{
    optdecl;
    char 	t_name[MAX_DIR_LINESIZE];
    char	t_options[MAX_DIR_LINESIZE];
    VDIR_ST		dir_st;            /* Directory contents used ... */
    VDIR		dir = &dir_st;     /* by individual lines         */
    int		retval;         /* Return value from subfunctions */
    ACL		wacl;		  /* Working access control list  */
    int		aclchk;	          /* Cached ACL check             */
    VLINK       clink;            /* For stepping through links   */
    int         tmp;
    OUTPUT_ST   out_st;
    OUTPUT      out = &out_st;
    long        n_magic_no;     /* magic # of link. XXX currently ignored.*/
    

    vdir_init(dir);
    reqtoout(req, out);

    *t_name = '\0';

    /* First arg is options.  All others are optional. */
    /* If a second argument is specified, it is the    */
    /* link for which the ACL is to be returned        */
    /* if the OBJECT option is specified, then args    */
    /* 2-5 identify the object instead of the link.  Object ACLs unimplemented,
       so we currently suppress those arguments. */
    tmp = qsscanf(next_word, "%!!s %!!'s %'*s %*d", 
                  t_options, sizeof t_options, 
                  t_name, sizeof t_name);
    /* Log and return a better message */
    if (tmp < 0)
        interr_buffer_full();
    if((tmp < 1) || 
       ((tmp < 2) && (!strequal(t_options,"DIRECTORY"))))  {
        creply(req,"ERROR too few arguments\n");
        plog(L_DIR_PERR,req,"Too few arguments: %s", command);
        return PFAILURE;
    }

    if (in_select(in, &n_magic_no))
        return error_reply(req, "LIST-ACL %'s", p_err_string);

    optstart(t_options);
    /* Do we need a better log message? */
    plog(L_DIR_REQUEST,req,"LA %s %s", client_dir,t_name);

    retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
    if(retval == DSRFINFO_FORWARDED) {
        dforwarded(req, client_dir, dir_magic_no, dir);
        return PSUCCESS;
    }

    /* If not a directory, say so */
    if(retval == DSRDIR_NOT_A_DIRECTORY) {
        creply(req,"FAILURE NOT-A-DIRECTORY\n");
        plog(L_DIR_ERR,req,"Invalid directory name: %s", client_dir);
        return PFAILURE;
    }

    wacl = NULL;

    /* Only LINK and DIRECTORY are presently implemented */
    if(opttest("LINK")) {
        /* Need to find the link so we can check its ACL */
        clink = dir->links;
        while(clink) {
            if(strequal(clink->name,t_name))
                break;
            clink = clink->next;
        }
        if(!clink) {
            clink = dir->ulinks;
            while(clink) {
                if(strcmp(clink->name,t_name) == 0)
                    break;
                clink = clink->next;
            }		 
        }
        if(!clink) {
            creplyf(req,"FAILURE NOT-FOUND LINK %'s",t_name);
            plog(L_DIR_ERR,req,"Link not found: %s %s", client_dir, t_name);
            vdir_freelinks(dir);
            return PFAILURE;
        }
        wacl = clink->acl;
        aclchk = check_acl(dir->dacl,clink->acl,req,"v");
    } else if(opttest("DIRECTORY")) {
        wacl = dir->dacl;
        aclchk = check_acl(dir->dacl,NULL,req,"V");
    } else {
        creply(req,"ERROR invalid option\n");
        plog(L_DIR_PERR,req,"Invalid option: %s", command);
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }

    /* If not authorized, say so */
    if(!aclchk) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR,req,"Unauthorized LIST-ACL: %s %s", client_dir,t_name);
        vdir_freelinks(dir);
        return PFAILURE;
    }

    if(wacl == NULL) {
        if(opttest("LINK")) /* Link default is diracl */
            retval = reply(req,"ACL DIRECTORY '' ''\n");
        else {
            reply(req,"ACL DEFAULT '' ''\n");
            retval = reply(req,"ACL SYSTEM '' ''\n");
        }
    } else {
        out_acl(out, wacl);
    }

#ifdef DATABASE_PREFIX          /* Keep database_acl alway set to the most
                           current version.  That way, if the database
                           ACL changes after server startup, you get
                           its most recent incarnation. */
    if(strcmp(client_dir,DATABASE_PREFIX) == 0) {
        aclfree(database_acl);
        database_acl = dir->dacl;
        dir->dacl = NULL;
    } 
#endif		    
    vdir_freelinks(dir);
    return retval;
}                           /* What does this go to? */
