/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>

#include <ardp.h>
#include <pfs.h>
#include <plog.h>
#include <psrv.h>
#include <perrno.h>
#include <pmachine.h>

#include "dirsrv.h"

/* This was create_directory */
create_object(RREQ req, char **commandp, char **next_wordp, INPUT in, 
              char client_dir[], int dir_magic_no)
{
    char	t_options[ARDP_PTXT_LEN_R];
    char 	t_name[ARDP_PTXT_LEN_R];
    char 	t_fname[ARDP_PTXT_LEN_R];
    VLINK	clink;             /* For stepping through links   */
    int         tmp;
    int		lpriv;		   /* LPRIV option  */
    int		retval;
    VDIR_ST	dir_st;            /* Directory contents used ... */
    VDIR	dir = &dir_st;     /* by individual lines         */

    clink = vlalloc();

    /* still have to read the remainder of the attributes */
    tmp = qsscanf(*next_wordp,"%'s %'s",
                 t_options,t_name);

    /* Log and return a better message */
    if(tmp < 2) {
        creply(req,"ERROR too few arguments");
        plog(L_DIR_PERR,req,"Too few arguments: %s",
             *commandp, 0);
        return PFAILURE;
    }

    /* For now, VIRTUAL and DIRECTORY options must be specified */
    if(!sindex(t_options, "VIRTUAL")  
       || !sindex(t_options, "DIRECTORY")) {
        creply(req,"ERROR only VIRTUAL directories implemented\n");
        plog(L_DIR_PERR,req,"Tried to create non-VIRTUAL or
non-directory object: %'s",
             *commandp, 0);
        return PFAILURE;
    }

    if(sindex(t_options,"LPRIV")) lpriv = 1;
    else lpriv = 0;

    plog(L_DIR_UPDATE,req,"%s", *commandp, 0);
    
    clink->name = stcopyr(t_name,clink->name);
    clink->target = stcopyr("DIRECTORY",clink->target);
    clink->host = stcopyr(hostwport,clink->host);

    /* come up with an unused hsoname for the new directory. */
    strcpy(t_fname,client_dir);
    strcat(t_fname,"/");
    strcat(t_fname,t_name);

    /* Try first a name unadorned with a :# */
    vdir_init(dir);
    if(dsrdir(t_fname, 0L, dir, (VLINK) NULL, 0) != DSRDIR_NOT_A_DIRECTORY) {
        char template[MAXPATHLEN];
        int i;
        
        strcpy(template, t_fname);
        strcat(template, ":%d");
        i = 1;
        for (;;) {
            qsprintf(t_fname, sizeof t_fname, template, i);
            vdir_freelinks(dir);
            if(dsrdir(t_fname, 0L, dir, (VLINK) NULL, 0) == DSRDIR_NOT_A_DIRECTORY)
                break;          /* t_fname now has an unused name */
            ++i;
        }
    }
    vdir_freelinks(dir);
    clink->hsoname = stcopyr(t_fname,clink->hsoname);

    retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
    if(retval == DSRFINFO_FORWARDED) 
        return dforwarded(req, client_dir, dir_magic_no, dir);

    /* If not a directory, say so */
    if(retval == DSRDIR_NOT_A_DIRECTORY) {
        creply(req,"FAILURE NOT-A-DIRECTORY\n");
        plog(L_DIR_ERR,req,"Invalid directory name: %'s", client_dir,0);
        return PFAILURE;
    }

    /* If not authorized, say so */
    if(!check_acl(dir->dacl,NULL,req,"I")) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR,req,"Unauthorized CREATE-DIRECTORY: %s %s",client_dir,
             t_name,0); 
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }

    retval = vl_insert(clink,dir,VLI_NOCONFLICT);
    if(retval == VL_INSERT_ALREADY_THERE) {
        creplyf(req,"FAILURE ALREADY-EXISTS %'s\n",clink->name);
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }
    else if(retval == VL_INSERT_CONFLICT) {
        creplyf(req,"FAILURE NAME-CONFLICT %'s\n",clink->name);
        plog(L_DIR_ERR,req,"Conflicting link already exists: %s %s",client_dir,
             clink->name,0);
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }

    if(!retval) retval = dswdir(client_dir,dir);

    /* We should check if the new directory already */
    /* exists and if so pick a new name for the     */
    /* physical instantiation ****                  */

    /* Free the directory links, since they're not relevant to the new child
       directory, but leave the ACL.  The parent's ACL will be kept around.
       DIR now belongs to the new child directory. */
    vllfree(dir->links); dir->links = NULL;
    vllfree(dir->ulinks); dir->ulinks = NULL;
    dir->inc_native = VDIN_NONATIVE;

    /* Add creator to the ACL */
    if(!lpriv || (!check_acl(dir->dacl,NULL,req,"AIlr"))) {
        ACL nacl;               /* new ACL entry */

        /* XXX this is really gross.  We really need to add a better entry, one
           which respects Kerberos authentication and multiple authentication
           mechanisms, etc.  Ditto for create_link */
        nacl = acalloc();
        nacl->acetype = ACL_ASRTHOST;
        if(lpriv) nacl->rights = stcopyr("AIlr",nacl->rights);
        else nacl->rights = stcopyr("ALRMDI",nacl->rights);
        nacl->principals = tkcopy(req->auth_info->principals);

        change_acl(&(dir->dacl),nacl,req,EACL_ADD|EACL_DIRECTORY,
                   dir->dacl); 
    }

    if(!retval) retval = dswdir(t_fname,dir);

    /* Free the ACL */
    vdir_freelinks(dir);

    /* if successful say so (need to clean this up) */
    if(!retval) reply(req,"SUCCESS\n");
    else creply(req,"FAILURE\n");
    return retval;
}
