/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>.
 */

#include <usc-copyr.h>

#include <pfs.h>

char *
p_uln_rindex(char *s, char c)
{
    char *lastmatch = NULL;

    for (; *s; ++s) {
        if (*s == '\\') {
            if (*++s == '\0')   /* special case this error condition */
                return lastmatch;          /* done */
            else
                continue;       /* don't match a quoted symbol */
        }
        if (*s == c) lastmatch = s;
    }
    return lastmatch;
}

char *
p_uln_index(char *s, char c)
{
    for (; *s; ++s) {
        if (*s == '\\') {
            if (*++s == '\0')   /* special case this error condition */
                return NULL;          /* done */
            else
                continue;       /* don't match a quoted symbol */
        }
        if (*s == c) return s;
    }
    return NULL;
}

