/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/wait.h>

#include <pfs.h>
#include <pcompat.h>
#include <psite.h>
#include <perrno.h>

extern int pfs_debug;
extern char *getenv(char *varname);

/* Retrieve file caching it in /tmp/pfs_cache */
pmap_cache(VLINK link, char *npath, int npathlen, TOKEN am_args)
{
    char		vcachebin[MAXPATHLEN];
    int 		pid;
    union wait 	status;
    int		tmp;
    char    *vcargv[12];        /* vcache's ARGV.  Enough to hold any known
                                   access method arguments. */
    char    **vcargvp = vcargv; /* pointer to vcache's argv. */
    char *p_binaries;

#if 0
    qsprintf(npath, npathlen, "/tmp/pfs_cache/%s%s%s",link->host,
            ((*(link->hsoname) == '/') ? "" : "/"),
            link->hsoname);
#endif
    qsprintf(npath, npathlen, "/tmp/pfs_cache/%s/%s%s%s", elt(am_args,2),
             elt(am_args, 0), ((*elt(am_args,4)  == '/') ? "" : "/"),
             elt(am_args, 4));

    /* Determine whether a cached copy already exists */
    /* If so, check to make sure we still have the    */
    /* current version, and if so use it              */
    /*  **** TO be IMPLEMENTED ***                    */

    /* Otherwise fetch a new copy */

    /* should really do this on our own without */
    /* calling system, but...                   */
    /* Set args first.  This makes it easier to debug() on debuggers that don't
       take kindly to subprocesses forking. */
    p_binaries = getenv("P_BINARIES");

#ifdef P_BINARIES
    if (!p_binaries)
        p_binaries = P_BINARIES;
#endif

    *vcargvp++ = "vcache";
    *vcargvp++ = npath;
    for (;am_args; am_args = am_args->next)
        *vcargvp++ = am_args->token;
    *vcargvp = NULL;

    pid = fork();
    if (pid < 0) {
        if (pfs_debug) {
            perror("pmap_cache(): failed to fork().");
        }
        return PMC_RETRIEVE_FAILED;
    }
#if 0
#define atline() if(pfs_debug > 10) fprintf(stderr, "%s:%d\n", __FILE__, __LINE__)
#else
#define atline() do ; while (0)
#endif
    if (pid == 0) {
        extern int errno;
        if (pfs_debug > 10)
            fprintf(stderr, "pmap_cache(): just forked.\n");
        atline();
        if (!p_binaries || !*p_binaries) {
            atline();
            /* In execl, add the "-m" option if cache to be managed */
            /* Add the "-r" option if existing item is out of date  */
            DISABLE_PFS(execvp("vcache",vcargv));
            atline();
            strcpy(vcachebin, "vcache"); /* for error reporting */
            atline();
        } else {
            atline();
            qsprintf(vcachebin, sizeof vcachebin, "%s/vcache",p_binaries);
            atline();
            /* In execl, add the "-m" option if cache to be managed */
            /* Add the "-r" option if existing item is out of date  */
            DISABLE_PFS(execv(vcachebin,vcargv));
            atline();
        }
        atline();
        if (pfs_debug) {
            fprintf(stderr,
                    "pmap_cache(): exec failed for %s (errno=%d): ",
                    vcachebin,errno);
            perror(NULL);
        }
        atline();
        exit(1);
    }
    else {
        wait(&status); 
    }
    tmp = status.w_T.w_Retcode;

    if(tmp) return(PMC_RETRIEVE_FAILED);

    /* Return PMC_DELETE_ON_CLOSE if cache is not being managed */
    return(PMC_DELETE_ON_CLOSE);

    /* return(PSUCCESS);*/

}
