/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1993 by the University of Southern California.
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <pcompat.h>
#include <pfs.h>                /* for definitions of myhostname and myaddress.
                                   */ 

#include <sys/param.h>
#include <netdb.h>
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 255      /* limit in 4.2BSD manual pages. */
#endif

static char	myhname[MAXHOSTNAMELEN + 1];
static long	myhaddr = 0L;

char 		*myhostname();

long 
myaddress(void)
{
    /* First time called, make sure myhostname has been run */
    if(!myhaddr) myhostname();
    return(myhaddr);
}

/* myhostname() always returns the official name of the host.
   This might be different from the version returned by gethostname(), and
   might well be different from the version stored in the 'hstname' environment
   variable defined in dirsrv.c */
   
char *
myhostname()
{
    static int	initialized = 0;

    /* First time called, find out hostname and remember it */
    if(!initialized++) {
        struct hostent	*current_host;

        gethostname(myhname,sizeof(myhname));
        /* gethostbyname reads files, so we must disable pfs */
        DISABLE_PFS(current_host = gethostbyname(myhname));
        strcpy(myhname,current_host->h_name);
        ucase(myhname);

        /* Save the address too */
        bcopy(current_host->h_addr,&myhaddr,4);
    }
    return(myhname);
}
