/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 *
 * Written  by bcn 1/93     For use in adrp_send
 */

#include <usc-copyr.h>

#include <stdio.h>

#include <ardp.h>
#include <pmachine.h>           /* for bcopy() */

extern int	ardp_priority;    /* Override for 0 priority    */
extern int	pfs_debug;

/*
 * ardp_headers - Add headers to packets to be sent to server
 *
 *   ardp_headers takes pointer to a request structure and adds headers to 
 *   all the packets in the trns list.  The fields for the headers are
 *   taken from other fields in the request structure.  If the priority is
 *   zero, it is taken from the global vairable ardp_priority.
 *
 *   If ardp_headers is called more than once, subsequent calls will
 *   update the headers to conform to changes in the request fields.
 */
ardp_headers(req)
    RREQ	req;
{
    PTEXT	ptmp;		/* Temporary packet pointer	      */
    unsigned short ftmp;	/* Temporary for values of fields     */
    int		old_hlength;    /* Old header length                  */

    ptmp = req->trns;

    while(ptmp) {
	old_hlength = ptmp->text - ptmp->start;

	/* XXX Should do further tests to make sure all packets present */
	if(ptmp->seq == 0) {
	    if (pfs_debug >= 1)
		fprintf(stderr, "ardp: sequence number not set in packet\n");
	    fflush(stderr);
	    return(ARDP_BAD_REQ);
	}

	if(req->priority || ardp_priority) {
	    ptmp->start = ptmp->text - 15;
	    *(ptmp->start) = (char) 15;
	    ptmp->length += 15 - old_hlength;
	    bzero(ptmp->start+9,4);
	    /* Priority flag */
	    *(ptmp->start+11) = 0x02;
	    /* Priority */
	    if(req->priority) ftmp = htons(req->priority);
	    else ftmp = htons(ardp_priority);
	    bcopy(&ftmp,ptmp->start+13,2);
	}
	else {
	    ptmp->start = ptmp->text - 9;
	    *(ptmp->start) = (char) 9;
	    ptmp->length += 9 - old_hlength;
	}
	/* Connection ID */
	bcopy(&(req->cid),ptmp->start+1,2);
	/* Sequence number */
	ftmp = htons(ptmp->seq);
	bcopy(&ftmp,ptmp->start+3,2);	
	/* Total packet count */
	ftmp = htons(req->trns_tot);
	bcopy(&ftmp,ptmp->start+5,2);	
	/* Received through */
	ftmp = htons(req->rcvd_thru);
	bcopy(&ftmp,ptmp->start+7,2);	
	ptmp = ptmp->next;
    }
    return(ARDP_SUCCESS);
}
