/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */
/* Munged by swa to handle multiple principals. */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>

static ACL	aclflist = NULL;
int		acl_count = 0;
int		acl_max = 0;

/*
 * acalloc - allocate and initialize access control list structure
 *
 *    ACALLOC returns a pointer to an initialized structure of type
 *    ACL.  If it is unable to allocate such a structure, it
 *    returns NULL.
 */
ACL
acalloc()
    {
	ACL	acl_ent;
	if(aclflist) {
	    acl_ent = aclflist;
	    aclflist = aclflist->next;
	}
	else {
	    acl_ent = (ACL) malloc(sizeof(ACL_ST));
	    if (!acl_ent) out_of_memory();
	    acl_max++;
	}

	acl_count++;

	/* Initialize and fill in default values */
#ifdef ALLOCATOR_CONSISTENCY_CHECK
        acl_ent->consistency = INUSE_PATTERN;
#endif
	acl_ent->acetype = 0;
	acl_ent->atype = NULL;
        acl_ent->rights = NULL;
        acl_ent->principals = NULL;
        acl_ent->restrictions = NULL;
        acl_ent->previous = NULL;
        acl_ent->next = NULL;
	return(acl_ent);
    }

/*
 * acfree - free an ACL structure
 *
 *    ACFREE takes a pointer to an ACL structure and adds it to
 *    the free list for later reuse.
 */
acfree(acl_ent)
    ACL		acl_ent;
    {
#ifdef ALLOCATOR_CONSISTENCY_CHECK
        assert(acl_ent->consistency == INUSE_PATTERN);
        acl_ent->consistency = FREE_PATTERN;
#endif
	acl_ent->acetype = 0;
	if(acl_ent->atype) stfree(acl_ent->atype);
	if(acl_ent->rights) stfree(acl_ent->rights);
        if(acl_ent->principals) 
            tklfree(acl_ent->principals);
	/* If acl_ent->restrict, error since not yet implemented */

	acl_ent->next = aclflist;
	if(aclflist) aclflist->previous = acl_ent;
	acl_ent->previous = NULL;
	aclflist = acl_ent;
	acl_count--;
	return(PSUCCESS);
    }

/*
 * aclfree - free an ACL structure
 *
 *    ACLFREE takes a pointer to an ACL structure frees it and any linked
 *    ACL structures.  It is used to free an entrie list of ACL
 *    structures.
 */
aclfree(acl_ent)
    ACL		acl_ent;
    {
	ACL	nxt;

	while(acl_ent != NULL) {
	    nxt = acl_ent->next;
	    acfree(acl_ent);
	    acl_ent = nxt;
	}
	return(PSUCCESS);
    }


ACL aclcopy(ACL acl)
{
    ACL retval = NULL;
    for ( ;acl ; acl = acl->next) {
        ACL new = acalloc();
        new->acetype = acl->acetype;
        if(acl->atype) new->atype = stcopyr(acl->atype,new->atype);
        if(acl->rights) new->rights = stcopyr(acl->rights,new->rights);
        if(acl->principals) new->principals = tkcopy(acl->principals);
        /* If struct restrict ever used, will need to copy that too. */
        APPEND_ITEM(new, retval);
    }        
    return(retval);
}
