/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>
#include <syscall.h>
#include <errno.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	errno;

pfs_open(vl,flags,mode)
    VLINK	vl;
    int		flags;
    int		mode;
    {
	char		npath[MAXPATHLEN];
	int		tmp;
	int		mapflags;
	int		open_return;

	if((flags & (O_ACCMODE)) == O_RDONLY) mapflags = MAP_READONLY;
	else mapflags = MAP_READWRITE;

	tmp = mapname(vl,npath,mapflags);

	if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) {
	    errno = ENOENT;
	    return(-1);
	}

	open_return = syscall(SYS_open,npath,flags,mode);
	if(tmp == PMC_DELETE_ON_CLOSE) unlink(npath);
	
	return(open_return);
    }

