/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>

#include <psite.h>
#include <pmachine.h>

#define SHELL_FILE	0
#define SHELL_CSH	1
#define SHELL_SH	2

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	int	shell = SHELL_CSH;  /* Shell type */

#ifdef CSH
	shell = SHELL_CSH;
#endif
#ifdef SH
	shell = SHELL_SH;
#endif

	if((argc > 1) && (strcmp(argv[1],"csh") == 0)) shell = SHELL_CSH;
	if((argc > 1) && (strcmp(argv[1],"sh") == 0)) shell = SHELL_SH;

	if(shell == SHELL_CSH) {
#ifdef USE_PATH
	    printf("set path=($path %s);\n",P_BINARIES); 
	    printf("alias vfsetup 'vfsetup \\!* > /tmp/vfs$$;source /tmp/vfs$$;rm /tmp/vfs$$'\n");
#else
	    printf("set path=(%s $path);\n",P_BINARIES); 
	    printf("alias vfsetup '%s/vfsetup \\!* > /tmp/vfs$$;source /tmp/vfs$$;rm /tmp/vfs$$'\n",P_BINARIES);
#endif
	}
	else if (shell == SHELL_SH) {
#ifdef USE_PATH
	    printf("PATH=$PATH:%s\n",P_BINARIES); 
	    printf("vfsetup () { (exec vfsetup $*) > /tmp/vfs$$;. /tmp/vfs$$;/bin/rm /tmp/vfs$$ }\n");
#else
	    printf("PATH=%s:$PATH\n",P_BINARIES); 
	    printf("vfsetup () { %s/vfsetup $* > /tmp/vfs$$;. /tmp/vfs$$;/bin/rm /tmp/vfs$$ }\n",P_BINARIES);
#endif P_BINARIES
	}

	exit(0);
    }

