#include <stdio.h>
#include <sys/types.h>

#ifdef MMAP
#include <sys/mman.h>
#endif

#include <ndbm.h>
#include <defines.h>
#include <structs.h>
#include <database.h>
#include <error.h>

#include <pfs.h>
#include <perrno.h>

#include "prarch.h"

char	*hostname = "THISHOST";
char	*hostwport = "THISHOST";

main(argc,argv)
     int	argc;
     char	*argv[];
{
  VLINK		clink;
  VLINK		conflink;
  VDIR_ST	dir_st;
  VDIR		dir = &dir_st;
  int		retval = 27;

  vdir_init(dir);

  if((argc != 2) && (argc != 3)) {
      fprintf(stderr,"Usage: prarch [host] name\n");
      exit(1);
  }
      
  /* Do only once */
  set_default_dir(DEFAULT_DBDIR);
  if((retval = open_db_files(DB_RDONLY)) != A_OK) {
      fprintf(stderr,"prarch: Can't open database\n");
      exit(1);
  }

  if(argc == 2) retval = prarch_match(argv[1],100,0,S_FULL_REGEX,dir,0); 
  else retval = prarch_host(argv[1],argv[2],dir,1); 

  clink = dir->links;

  while(clink) {
    conflink = clink;
    while(conflink) {
      printf("\n      Name: %s\n",conflink->name);
      printf("   ObjType: %s\n",conflink->type);
      printf("  LinkType: %s\n",((conflink->linktype == 'U') ? "Union" : "Standard"));
      printf("  HostType: %s\n",conflink->hosttype);
      printf("      Host: %s\n",conflink->host);
      printf("  NameType: %s\n",conflink->nametype);
      printf("  Pathname: %s\n",conflink->filename);
      if(conflink->version) printf("   Version: %d\n",conflink->version);
      printf("     Magic: %d\n",conflink->f_magic_no);
      conflink = conflink->replicas;
    }
    clink = clink->next;
  }
  	
}

