/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <pmachine.h>
/*
 * nlsindex - Find first instance of string 2 in string 1 following newline
 *
 *	      NLSINDEX scans string 1 for the first instance of string
 *	      2 that immediately follows a newline.  If found, NLSINDEX
 *	      returns a pointer to the first character of that instance.
 *	      If no instance is found, NLSINDEX returns NULL (0).
 *
 *    NOTE:   This function is only useful for searching strings that
 *            consist of multiple lines.  s1 is assumed to be preceeded
 * 	      by a newline.  Thus, if s2 is at the start of s1, it will
 *	      be found.
 *    ARGS:   s1 - string to be searched
 *            s2 - string to be found
 * RETURNS:   First instance of s2 in s1, or NULL (0) if not found
 */
char *
nlsindex(s1,s2)
    char	*s1;		/* String to be searched */
    char	*s2;		/* String to be found    */
    {
	char	*curline = s1;	/* Pointer to start of current line */

	/* In case s2 appears at start of s1 */
	if(strncmp(curline,s2,strlen(s2)) == 0)
	    return(curline);

	/* Check remaining lines of s1 */
	while((curline = index(curline,'\n')) != NULL) {
	    curline++;
	    if(strncmp(curline,s2,strlen(s2)) == 0)
		return(curline);
	}

	/* We didn't find it */
	return(NULL);
    }

