/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;
extern char	*acltypes[];

/*
 *
 *   Flags:      
 */
modify_acl(dlink,lname,a,flags)
    VLINK	dlink;		/* Directory link                 */
    char	*lname;		/* Link name                      */
    ACL		a;		/* ACL entry to add/delete/modify */
    int		flags;		/* Flags                          */
    {
        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */
	char	options[100];   /* List of options                           */
	char	*optptr;        /* Options minus leading + */
	int	tmp;           

	char	qlname[MAX_DIR_LINESIZE]; /* Quoted link name */
	char	qatype[MAX_DIR_LINESIZE]; /* Quoted auth type */
	char	qrights[MAX_DIR_LINESIZE]; /* Quoted auth type */

	int	fwdcnt = MAX_FWD_DEPTH;
	char	fwdhst[MAX_DIR_LINESIZE];
	char	fwdfnm[MAX_DIR_LINESIZE];

	PAUTH	authinfo;

	*options = '\0';

	if(flags&MACL_NOSYSTEM) strcat(options,"+NOSYSTEM");
	if(flags&MACL_NOSELF) strcat(options,"+NOSELF");
	if(!((flags&MACL_OP)^MACL_DEFAULT)) strcat(options,"+DEFAULT");
	if(!((flags&MACL_OP)^MACL_SET)) strcat(options,"+SET");
	if(!((flags&MACL_OP)^MACL_INSERT)) strcat(options,"+INSERT");
	if(!((flags&MACL_OP)^MACL_DELETE)) strcat(options,"+DELETE");
	if(!((flags&MACL_OP)^MACL_ADD)) strcat(options,"+ADD");
	if(!((flags&MACL_OP)^MACL_SUBTRACT)) strcat(options,"+SUBTRACT");
	if(!((flags&MACL_OTYPE)^MACL_LINK)) strcat(options,"+LINK");
	if(!((flags&MACL_OTYPE)^MACL_DIRECTORY)) strcat(options,"+DIRECTORY");
	if(!((flags&MACL_OTYPE)^MACL_OBJECT)) strcat(options,"+OBJECT");
	if(!((flags&MACL_OTYPE)^MACL_INCLUDE)) strcat(options,"+INCLUDE");

	optptr = options + 1;

	if(lname == NULL) lname = "";

	if(strcmp(dlink->type,"NULL") == 0) return(PFS_EXT_USED_AS_DIR);
	if(strcmp(dlink->type,"EXTERNAL") == 0) return(PFS_EXT_USED_AS_DIR);

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

    startover:

	request = ptalloc();

	strcpy(qlname,quote(lname));
	strcpy(qatype,quote(a->atype));
	strcpy(qrights,quote(a->rights));

	sprintf(request->start,
		"VERSION %d %s\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nMODIFY-ACL %s %s %s %s %s %s\n",
		VFPROT_VNO, PFS_SW_ID, authinfo->auth_type, 
		authinfo->authenticator, dlink->filename, optptr, qlname,
		acltypes[a->acetype], qatype, qrights, quote(a->principals));
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	perrno = 0;
	resp = dirsend(request,dlink->host,0);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	/* If we don't get a response, then return error */
	if(resp == NULL) return(perrno);

	/* Here we must parse reponse - While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;

	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		case 'F': /* FAILURE or FORWARDED */
		    /* FORWARDED */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			if(fwdcnt-- <= 0) {
			    ptlfree(resp);
			    perrno = PFS_MAX_FWD_DEPTH;
			    return(perrno);
			}
			/* parse and start over */
			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %*d %*d", 
				     fwdhst,fwdfnm);
			dlink->host = stcopyr(fwdhst,dlink->host);
			dlink->filename = stcopyr(fwdfnm,dlink->filename);

			if(tmp < 2) {
			    ptlfree(resp);
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			ptlfree(resp);
			goto startover;
		    }
		    /* If FAILURE or anything else scan error */
		    goto scanerr;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'S': /* SUCCESS */
		    if(strncmp(line,"SUCCESS",7) == 0) {
			ptlfree(resp);
			return(PSUCCESS);
		    }
		    goto scanerr;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(perrno);
		    }
		    goto scanerr;

		scanerr:
		default:
		    if(*line && (tmp = scan_error(line))) {
			ptlfree(resp);
			return(tmp);
		    }
		    break;
		}
	    }

	    resp = resp->next;
	    ptfree(vtmp);
	}
	
	perrno = DIRSRV_BAD_FORMAT;
	return(perrno);
    }
