/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <sgtty.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>

#include <plog.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>

extern int	f;

/*
 * reply - reply takes an address to which a reply is to be sent, and
 * a response to be sent.  It then adds the response to a buffer and
 * sends the bufered responses if the buffer length approaches the maximum
 * packet size.  reply keeps track of the packet number and tags
 * outgoing packets if necessary or a multi packet response.
 */
reply(req,message)
    PREQ		req;
    char		*message;
    {
	int		last_seq = 0;
	if(!req->cpkt) req->cpkt = ptalloc();

	/* Here we need to check lengths and add message number if necessary */
	if((strlen(message) + req->cpkt->length + SEQ_SIZE) > MAXPKT) {
	    if(!req->cpkt->seq) req->cpkt->seq = 1;
	    last_seq = req->cpkt->seq;
	    transmit(req);
	    req->cpkt = ptalloc();
	    req->cpkt->seq = last_seq + 1;
	}

	strcpy(req->cpkt->start + req->cpkt->length,message);
	req->cpkt->length += strlen(message);
	return(PSUCCESS);
    }

/*VARARGS2*/

/*
 * replyf - replyf performs the same function as reply except that the
 * message to be sent is provided in the same form as for printf.  A
 * <CR> will be added at the end of the message.
 */

replyf(req,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
    PREQ		req;
    char 		*format;
    char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
    char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
    {
	char 	buf[MAX_DIR_LINESIZE];

	sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
	strcat(buf,"\n");

	/* Perform the reply and pass through any error codes */
	return(reply(req,buf));
    }


/*
 * sendm - sendm takes an address to which a reply is to
 * be sent and forces any queued messages to actually be sent.  This is
 * used at the end of any multiple message response.  sendm also
 * takes an optional message to be sent, thus allowing a single messages
 * to be specified and sent in a single call.
 *
 * If sendm is called and no messages are queued or specified, an
 * error will be returned.
 */
sendm(req,message)
    PREQ		req;
    char		*message;
    {
	/* Add the message to those already queued */
	if(message && *message) reply(req,message);

	/* Return an error if there is no response waiting */
	/* by this point                                   */
	if(!req->cpkt) return(PFAILURE);

	/* Send the queued messages and pass through any error code */
	req->cpkt->seq *= -1;
	return(transmit(req));
    }

/*VARARGS2*/

/*
 * sendmf - sendmf performs the same function as sendm, but the optional
 * message to be sent is specified in the same manner as for a printf.
 * A <CR> will be added at the end of the message.
 */
sendmf(req,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
    PREQ		req;
    char 		*format;
    char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
    char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
    {
	char 	buf[MAX_DIR_LINESIZE];

	sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
	strcat(buf,"\n");

	/* Send the message and pass through any error codes */
	return(sendm(req,buf));
    }
