/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

/*
 * quote - quote string if necessary
 *
 *	      QUOTE takes a string and quotes it if it contains special
 *            characters.  The null string is also quoted.
 *
 *    ARGS:   s - string to be quoted
 *            
 * RETURNS:   The quoted string.  If quoting is required, the string
 *	      appears in static storage, and must be copied if 
 *            it is to last beyond the next call to quote.
 *            If s is null, or the null string, '' is returned.
 *
 *    BUGS:   Still needs to check for additional illegal embedded characters
 */
char *
quote(s)
    char	*s;		/* String to be quoted */
    {
	/* Should malloc so no dependancy on size */
	static char	quoted[200];
	char		*qp = quoted;
	char		*sp = s;
	int		needsquoting = 0;

	*qp++ = '\'';

	if(!sp) sp = "";

	while(*sp) {
	    if ((*sp < '#') || (*sp > '~')) needsquoting++;
	    if (*sp == '\'') *(qp++) = '\'';
	    *(qp++) = *sp++;
	}

	*(qp++) = '\'';
	*(qp++) = '\0';

	if((qp == quoted + 3) || needsquoting) return(quoted);
	return(s);
    }
