/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;

PATTRIB pget_at(link,atname)
    VLINK	link;
    char	*atname;
    {
        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */
	PATTRIB	astart = NULL;	/* Start of list of attributes               */
	PATTRIB ap;		/* Temporary attribute pointer               */
	PATTRIB alast = NULL;	/* Last attribute filled in		     */

	/* For ACCESS-METHOD from external link */
	char	am[MAX_DIR_LINESIZE];
	char	amparam[MAX_DIR_LINESIZE];

	int	fwdcnt = MAX_FWD_DEPTH;
	char	fwdhst[MAX_DIR_LINESIZE];
	char	fwdfnm[MAX_DIR_LINESIZE];

	PAUTH	authinfo;

	/* Only the access-method is associated with an external link */

	if(strcmp(link->type,"NULL") == 0) return(NULL);

	if(sscanf(link->type,"EXTERNAL(%[^,)],%[^)]",am,amparam) > 0) {
	    if(strcmp(atname,"ACCESS-METHOD") == 0) {
		if(strcmp(am,"NFS") == 0) {
		    /* Fill in NFS response *****/
		    /* sprintf(ainfo,"%s %s",amparam,link->filename); */
		}
		else if(strcmp(am,"AFTP") == 0) {
		    /* Fill in AFTP response *****/
		    /* sprintf(ainfo,"%s %s",link->filename,amparam); */
		}
		return(astart);
	    }
	    else return(NULL);
	}

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

    startover:

	request = ptalloc();

	sprintf(request->start,
          "VERSION %d %s\nAUTHENTICATOR %s %s\nGET-OBJECT-INFO %s ID ASCII %s 0 %d\n",
		VFPROT_VNO, PFS_SW_ID, authinfo->auth_type, 
		authinfo->authenticator, atname, link->filename, 
		link->f_magic_no);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,link->host,0);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	/* If we don't get a response, then return error */
	if(resp == NULL) return(NULL);


	/* Here we must parse reponse   */
	/* While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;

	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		    /* Temporary variables to info */
		    int		tmp;

		case 'N': /* NONE-FOUND */
		    /* NONE-FOUND, we just have no attributes to insert */
		    if(strncmp(line,"NONE-FOUND",10) == 0) 
			break;
		    goto scanerr;

		case 'O': /* OBJECT-INFO */ 
		    /* If anything but OBJECT-INFO scan error */
		    if(strncmp(line,"OBJECT-INFO",11) != 0) goto scanerr;

		    ap = parse_attribute(line);
		    if(!ap) break;

		    if(astart) {
			ap->previous = alast;
			alast->next = ap;
			alast = ap;
		    }
		    else {
			astart = ap;
			alast = ap;
			ap->previous = NULL;
		    }

		    break;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'F':/* FORWARDED, FAILURE */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			if(fwdcnt-- <= 0) {
			    ptlfree(resp);
			    perrno = PFS_MAX_FWD_DEPTH;
			    return(NULL);
			}
			/* parse and start over */
			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %d %d", 
				     fwdhst,fwdfnm,
				     &(link->version), &(link->f_magic_no));

			link->host = stcopyr(fwdhst,link->host);
			link->filename = stcopyr(fwdfnm,link->filename);

			if(tmp < 2) {
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			
			ptlfree(resp);
			goto startover;
		    }
		    /* If FAILURE or anything but FORWARDED, scan error */
		    goto scanerr;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(NULL);
		    }
		    goto scanerr;

		scanerr:
		default:
		    if(*line && (tmp = scan_error(line))) {
			ptlfree(resp);
			return(NULL);
		    }
		    break;
		}
	    }

	    resp = resp->next;
	    ptfree(vtmp);
	}


	ptlfree(resp);
	return(astart);
    }

	    
