/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;

/*
 */
add_vlink(direct,lname,l,flags)
    char	*direct;	/* Virtual name for the directory	  */
    char	*lname;		/* Name of the new link                   */
    VLINK	l;		/* Link to be inserted                    */
    int		flags;		/* Options for link to add 		  */
    {
	char		*dirhst;	   /* Host of current directory   */
	char		*remdir;	   /* Dir on remote host	  */
	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

        PTEXT		request;	/* Text of request to dir server  */
	PTEXT		resp;	    	/* Response from dir server	  */

	int		fwdcnt = MAX_FWD_DEPTH;
	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];

	PAUTH		authinfo;
	int		tmp;

	vdir_init(dir);

	/* If magic number has been modified, set it back to 0 */
	if(l->f_magic_no < 0) l->f_magic_no = 0;

        /* We must first find the directory into which the link  */
        /* will be inserted                                      */

	tmp = rd_vdir(direct,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

    startover:

	request = ptalloc();

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d %s\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nCREATE-LINK %c %s %s %s %s %s %s %d %d\n",
		VFPROT_VNO, PFS_SW_ID, authinfo->auth_type, 
		authinfo->authenticator, remdir,
		((flags & AVL_UNION) ? 'U' : 'L'),
		quote(lname), l->type, l->hosttype,l->host,
		l->nametype, l->filename,l->version,l->f_magic_no);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we must parse reponse - While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;

	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		case 'F': /* FAILURE or FORWARDED */
		    /* FORWARDED */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			if(fwdcnt-- <= 0) {
			    ptlfree(resp);
			    perrno = PFS_MAX_FWD_DEPTH;
			    return(perrno);
			}
			/* parse and start over */
			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %*d %*d", 
				     fwdhst,fwdfnm);
			dirhst = stcopy(fwdhst);
			remdir = stcopy(fwdfnm);

			if(tmp < 2) {
			    ptlfree(resp);
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			ptlfree(resp);
			goto startover;
		    }
		    /* If FAILURE or anything else scan error */
		    goto scanerr;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'S': /* SUCCESS */
		    if(strncmp(line,"SUCCESS",7) == 0) {
			ptlfree(resp);
			return(PSUCCESS);
		    }
		    goto scanerr;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(perrno);
		    }
		    goto scanerr;

		scanerr:
		default:
		    if(*line && (tmp = scan_error(line))) {
			ptlfree(resp);
			return(tmp);
		    }
		    break;
		}
	    }

	    resp = resp->next;
	    ptfree(vtmp);
	}
	
	perrno = DIRSRV_BAD_FORMAT;
	return(perrno);
    }
