/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

/*
 * psite.h - site selected parameters for Prospero
 *
 * This file contains local definitions for the Prospero utilities.
 * It is expected that it will be different on different systems.
 */

/*
 * Define USE_PATH if the user's search path is to be used
 * to find the client executables.  If not defined, the user
 * programs must reside in the directory specified by P_BINARIES.
 * If USE_PATH is defined it is the responsibility of the user or
 * system administrator to make sure that the user's path includes the
 * directory identified by P_BINARIES. 
 *
 * #define USE_PATH
 */

/*
 * P_BINARIES defines the name of the directory in which
 * Prospero binaries will be installed.
 */
#define P_BINARIES            "/usr/pfs/bin"

/*
 * Distribution options.  By default, these options are supported.
 * if your distribution does not include support for filters
 * define P_NO_FILTERS.  If your distribution does not include
 * the compatability library define P_NO_PCOMPAT.
 *
 * #define P_NO_FILTERS
 * #define P_NO_PCOMPAT
 */
#define P_NO_FILTERS

/*
 * P_AFS is the name of the directory under which AFS files are found.
 * If should be set only if your system supports the Andrew File System.  
 *
 * #define P_AFS "/afs"  
 */

/*
 * If NFS is supported P_NFS should be defined.  If set, NFS may
 * be used to retrieve files from remote systems.  
 *
 * #define P_NFS
 */

/*
 * Section 1: System Definitions for the Prospero Server
 *
 * This section contains definitions that will vary from system to system.
 * They are used only on systems that are running the Prospero server.
 */

/*
 * PROSPERO_CONTACT specifies the e-mail address of the individual
 * or individuals responsible for running the Prospero server on the 
 * local system.  If specified, this string will appear in responses to 
 * status requests.  This definition is optional.
 *
 * #define PROSPERO_CONTACT "yourname@site"
 */

/* 
 * PSRV_HOSTNAME specifies the name of the host on which the server 
 * will run.  It only needs to be defined if gethostbyname does not 
 * return the name of the host as a fully qualified domain name.
 *
 * #define PSRV_HOSTNAME	      "HOST.ORG.DOMAIN"
 *
 */

/* 
 * P_USER_ID and P_GROUP_ID specify the user and group names under which
 * the Prospero server will run.
 */
#define P_USER_ID             "pfs"
#define P_GROUP_ID            "pfs"

/* 
 * P_RUNDIR is the name of the directory under which the Prospero
 * server will run.  If left out, it defaults to /tmp.
 *
 * #define P_RUNDIR	      "/tmp"
 */

/*
 * PSRV_ROOT defines that part of the system's directory tree for which
 * directory information will be readable over the network.  Directory
 * information will also be available for files under AFTPDIRECTORY and
 * AFSDIRECTORY if these access methods are supported.
 *
 * If PSRV_ROOT is not defined, then directory information will only be
 * available for those files under AFTPDIRECTORY or AFSDIRECTORY.
 *
 * Note: PSRV_ROOT must be the true name for the directory after
 *       all symbolic links have been expanded.
 *
 * #define PSRV_ROOT		"/"
 */

/*
 * PSRV_READ_ONLY specifies that the server is only to accept
 * operations that read the directory structure. No changes to virtual
 * directories stored on this system will be allowed.  NODOTDOT is used to
 * disallow the use of path names that include "..".  If you are
 * restricting the part of the directory tree which will be accessible
 * (i.e. if PSRV_ROOT is other than "/"), NODOTDOT should be set.
 *
 * #define PSRV_READ_ONLY
 * #define NODOTDOT
 */
#define PSRV_READ_ONLY
#define NODOTDOT

/*
 * P_SHADOW is the name of the shadow hierarchy that will contain additional 
 * information about Prospero files.  P_STORAGE is the name of the directory
 * under which new files can be created, if that option is supported by
 * your distribution.  Both names are relative to the home directory for the
 * user ID specified by P_USER_ID.  
 */
#define P_SHADOW              "shadow"
#define P_STORAGE             "pfsdat"

/*
 * If P_UNDER_UDIR is defined, pstart calculates the full path names of
 * of the directories corresponding to P_SHADOW and P_STORAGE by
 * finding the home directory for the Prospero user ID, then appending
 * P_SHADOW or P_STORAGE.
 *
 * If P_UNDER_UDIR is not defined, or if dirsrv is called directly,
 * the full path names are taken from P_FSHADOW and P_FSTORAGE.  These
 * should be stable names for those directories.  They may be aliases
 * (symbolic links) if the directories move around.  If they are symbolic
 * links, the links should be updated whenever the directories move.
 *
 * Note that if P_UNDER_UDIR is set, the full path names are calculated 
 * only when the Prospero server is started by pstart.  If you expect
 * to start the server by hand (for example, when debugging), P_FSHADOW 
 * and P_FSTORAGE should also be defined.
 */
#define P_UNDER_UDIR

#define P_FSHADOW	      "/usr/pfs/shadow"
#define P_FSTORAGE	      "/usr/pfs/pfsdat"

/*
 * AFTPDIRECTORY contains the name of the root directory as seen through
 * anonymous FTP.  It is used to determine which files may be accessed
 * using the anonymous FTP access mechanism, and to determine the file name
 * that must be used when doing so.  It also adds to the set of files about 
 * which directory information is available.
 *
 * Note: AFTPDIRECTORY should be a stable name for the FTP directory.
 *       It may be an alias (symbolic link) if the FTP directory
 *       moves around.  If it is a symbolic link, that symbolic link should
 *       be updated whenever the directory moves.
 */
#define AFTPDIRECTORY           "/usr/ftp"

/*
 * AFTPUSER contains the name of the anonymous FTP user (usually ftp)
 * If defined, pstart will look up the home directory for this user
 * and use it instead of AFTPDIRECTORY.  If it fails, the value of
 * AFTPDIRECTORY (defined above) will be used.  
 *
 * Note that if AFTPUSER is set, the path name of the FTP directory is
 * calculated only when the Prospero server is started by pstart. 
 * If you expect to start the server by hand (for example, when
 * debugging), AFTPDIRECTORY should also be defined.
 *
 * Also note that when started by pstart, if AFTPUSER is defined, the
 * path taken from the password file will override that specified by
 * AFTPDIRECTORY.  If AFTPDIRECTORY is a stable path, do not define 
 * AFTPUSER.
 *
 * #define AFTPUSER 		"ftp"
 */

/*
 * NFS_EXPORT should be defined if your system allows others to 
 * access files using NFS.  If defined, you will have to modify
 * lib/psrv/check_nfs.c so that the directory server is aware of 
 * your system's policy for NFS mounts (this is necessary so that 
 * the directory server will not tell the client to use NFS when
 * such access is not supported).
 *
 * #define NFS_EXPORT
 */

/*
 * AFSDIRECTORY contains the name of the root of the AFS directory
 * hierarchy.  It should only be defined if your host supports AFS
 * and you are willing to make information about AFS files available
 * through your server.  AFSDIRECTORY is used to to determine which files
 * may be accessed using the AFS access mechanism.  It also adds to
 * the set of files about which directory information is available.
 *
 * Note: AFSDIRECTORY must be the true name for the directory
 *       after all symbolic links have been expanded.
 *
 * #define AFSDIRECTORY           "/afs"
 */

/*
 * DATABASE_PREFIX contains the name of the prefix to be used for directory
 * names when the Prospero server is to provide information from sources 
 * other than the file system.  On most systems this option will not be
 * supported.
 *
 * #define DATABASE_PREFIX           "DB"
 */

/*
 * DEFAULT_ACL, SYSTEM_ACL, and OVERRIDE_ACL are access control lists used 
 * to control access to Prospero directories.  DEFAULT_ACL applies
 * to those directories for which no individual access control list
 * has been specified.  All access control lists initially include
 * SYSTEM_ACL, but the entry may be explicitly removed by the administrator
 * of a directory or link.  OVERRIDE_ACL grants rights to a directory 
 * regardless of the contents of any other access control list.  Up to
 * two entries for each of these lists may be specified in this include 
 * file.  If more are needed, see the initialize_defaults routine in *
 * lib/psrv/check_acl.c.
 */
#define DEFAULT_ACL_1  {ACL_ANY, NULL, "Yvlr", NULL}
#define DEFAULT_ACL_2  {ACL_ASRTHOST, NULL, "YIvlrmd", "*@%.%.%.*"}
#define SYSTEM_ACL_1   {ACL_ASRTHOST, NULL, "ALRMDI", "prospero@128.9.*.*"}
#define OVERRIDE_ACL_1 {ACL_OWNER, NULL, "A", NULL}
#define OVERRIDE_ACL_2 {ACL_TRSTHOST, NULL, "A", "root@%.%.%.%"}

/*
 * PFS_LOGFILE is the name of the file in which events are logged.  
 * By default Prospero logs all requests.  If you would like to
 * change the list of events that are logged, or if you would
 * like to use syslog for logging, edit the file plog.h.
 */
#define PFS_LOGFILE		"/usr/pfs/pfs.log"

/*
 * DSHADOW and DCONTENTS are the names of the file in the shadow
 * directory used to store information about directories.  There
 * should be no need to change them.
 */
#define DSHADOW			".directory#shadow"
#define DCONTENTS		".directory#contents"

/*
 * Section 2: Site Definitions for the Prospero Applications
 *
 * The definitions in the following section define the Prospero site.
 * They will not change from system to system.  These definitions
 * should only be changed if you are setting up your own prospero
 * site.  Setting up a site is different than installing the software
 * on a new system.  Unless your site supports storage of new virtual
 * systems, do not change these definitions. 
 */

/*
 * P_SITE_HOST and DIRECTORY define the system level name of the
 * virtual directory under which site data and meta-data are stored. 
 * It will vary from site to site.
 */
#define P_SITE_HOST           "PROSPERO.ISI.EDU"
#define P_SITE_DIRECTORY      "/pfs/pfsdat/guest"

/*
 * P_SITE_MASTER_VSLIST is the name of the virtual directory (relative
 * to P_SITE) under which reference to local virtual systems can be
 * found.  When setting up a new site, choose a one component name
 * that seems appropriate.
 */
#define P_SITE_MASTER_VSLIST  "vs_root_isi-guest"

/*
 * P_MASTER_VS is the name (relative to MASTER_VSLIST) of the virtual
 * system to be used when creating new virtual systems with newvs.
 * There should be no need to change these definitions.
 */
#define P_MASTER_VS           "master"
#define P_PROTOTYPE_VS        "prototype"

/* 
 * P_SITE_STORAGE is the name (relative to master) of a directory
 * with references to the storage areas of the individual systems that 
 * compose a site. There should be no need to change this
 * definitions.
 */
#define P_SITE_STORAGE        "pfs_storage"

/*
 * P_VS_STORAGE is the name (relative to the directories named in
 * P_SITE_STORAGE) of the directory under which new virtual systems
 * may be stored.  There should be no need to change this definition.
 */
#define P_VS_STORAGE          "local_vsystems"

/*
 * P_GLOBALE_VS_ROOT* is a reference to the global root for the
 * underlying ugly-names of virtual systems.  These definitions must not
 * be changed.
 */
#define P_GLOBAL_VS_ROOT_HOST "PROSPERO.ISI.EDU"
#define P_GLOBAL_VS_ROOT_FILE "/pfs/pfsdat/vs_root_g"
