/*
 * Copyright (c) 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1991     to restart server on command or failure
 * Modified by bcn 1/20/93  to use new arguments to dirsrv
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <strings.h>
#include <errno.h>              /* for def of external errno variable */
#include <sys/param.h>

#include <ardp.h>
#include <pfs.h>
#include <pserver.h>
#include <plog.h>
#include <pmachine.h>

#include <pparse.h>
#include "dirsrv.h"

extern int sys_nerr;
extern char *sys_errlist[];

/*
 * restart server restarts the server by calling exec.  Before
 * restarting, it logs the current statisitcs which would otherwise
 * be lost.
 */
restart_server(fcount,estring)
    int		fcount;		/* Failure count */
    char	*estring;	/* Error string  */
{
    char	*dsargv[50]; /* Args to dirsrv          */
    int		dsargc = 0;  /* Count of args to dirsrv */
    char	fault_flag[10];
    char	pport_flag[20];
    static int	still_going = 0; /* set if restart attempt in progress */
    int		f;

    if(still_going > 10) exit(1);  /* It's the energizer rabbit */

    if(still_going++ == 0) {       /* If first time through     */
	/* Log statistics before we forget them on restart */
	log_server_stats();
	close_plog();
    }

    /* Close all files except stdin, stdout, and stderr */
    /* which should still be /dev/null, and in_port     */
    /* which we might not be able to reopen             */
    for (f = 3; f < OPEN_MAX; f++) {
	if(f != in_port) (void) close(f);
    }

    dsargv[dsargc++] = "dirsrv"; 

    /* Port to listen on */
    if(in_port >= 0) {
	sprintf(pport_flag, "-p%d", in_port);
	dsargv[dsargc++] = pport_flag;
    }
    if(portname) {
	dsargv[dsargc++] = "-p";
	dsargv[dsargc++] = portname;
    }	

    if(estring) {
	dsargv[dsargc++] = "-E";
	dsargv[dsargc++] = estring;
    }

    if(fcount > 0) {
	sprintf(fault_flag, "-F%d", (fcount < 99999 ? fcount : 99999));
	dsargv[dsargc++] = fault_flag;
    }

    dsargv[dsargc++] = "-h";
    dsargv[dsargc++] = hostname;

    dsargv[dsargc++] = "-S";
    dsargv[dsargc++] = shadow;

    dsargv[dsargc++] = "-T";
    dsargv[dsargc++] = pfsdat;     /* storage */

    if(root && *root) {
	dsargv[dsargc++] = "-r";
	dsargv[dsargc++] = root;
    }

    if(aftpdir && *aftpdir) {   
	dsargv[dsargc++] = "-f";
	dsargv[dsargc++] = aftpdir;
    }

    if(aftpdir && *aftpdir) {   
	dsargv[dsargc++] = "-a";
	dsargv[dsargc++] = afsdir;
    }

    /* logfile if changed on command line */
    if(logfile_arg) {           
	dsargv[dsargc++] = "-L";
	dsargv[dsargc++] = logfile_arg;
    }

    dsargv[dsargc++] = NULL;

    /* Reinstate the signal that caused the fault */
    sigsetmask(0);

    /* Restart the server specifying the appropriate flags */
    execv(P_DIRSRV_BINARY,dsargv);

    /* If we get here, the exec failed */
    plog(L_FAILURE,NOREQ,
         "***Failure - Couldn't restart server %s (%s) - execv exited with \
error # %d, error name %s:  - aborting***",
         P_DIRSRV_BINARY, estring ? estring : "", errno,
         sys_nerr < errno ? "Unprintable" : sys_errlist[errno]);
    exit(1);
}

