/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1991, 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 *
 * Written  by bcn 1989-92  as pfs.h in the Prospero distribution
 * Modified by bcn 1/93     separate include file and extended preq structure
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#ifndef ARDP_H_INCLUDED
#define ARDP_H_INCLUDED

#include <sys/time.h>
#include <sys/types.h>
/* Unfortunately, some buggy compilers (in this case, gcc 2.1 under
   VAX BSD 4.3) get upset if <netinet/in.h> is included twice. */
#if !defined(IP_OPTIONS)
#include <netinet/in.h> 
#endif

#include <list_macros.h>

#define PROSPERO

#ifdef PROSPERO
#define	     ARDP_DEFAULT_PEER	 "dirsrv"/* Default destination port name   */
#define	     ARDP_DEFAULT_PORT    1525   /* Default destination port number */
#endif /* PROSPERO */

#define      ARDP_BACKOFF(x)   (2 * x)   /* Backoff algorithm               */
#define      ARDP_DEFAULT_TIMEOUT    4	 /* Default time before retry (sec) */
#define      ARDP_DEFAULT_RETRY	     3	 /* Default number of times to try  */
#define	     ARDP_WINDOW_SZ	    75   /* Maximum packets to send at once */
#define	     ARDP_FIRST_PRIVP	   901	 /* First prived local port to try  */
#define	     ARDP_NUM_PRIVP	    20	 /* Number of prived ports to try   */
#define	     ARDP_PTXT_HDR	    64   /* Max offset for start            */
#define	     ARDP_PTXT_LEN	  1250   /* Max length for data to send     */
#define	     ARDP_PTXT_LEN_R	  1405	 /* Max length for received data    */

/* Rationale for MAX_PTXT_LEN_R: According to IEEE std. 802.5, 1492 is the  */
/* max data length for an ethernet packet.  IP implementers tend to use     */
/* this information in deciding how large a packet could be sent without IP */
/* fragmentation occurring.  Subtract 16 octets for the IP header.          */
/* Subtract 8 octets for UDP header. The maximum ARDP header size is 6 bits */
/* or 64, so subtract 64 more for the ARDP header.  This leaves 1404 bytes. */
/* Note we only generate 1250 bytes because there are preV5 implementations */
/* out there with smaller limits. We also add one to MAX_PTXT_LEN_R to make */
/* sure there is always room to insert a null if needed.                    */

/* Must leave room to insert header when sending and to strip it on receipt */
#define		ARDP_PTXT_DSZ	ARDP_PTXT_LEN_R+2*ARDP_PTXT_HDR

/* Definition of text structure used to pass around each packet */
struct ptext {
    int		       seq;		  /* Packet sequence number	    */
    int		       length;		  /* Length of text (from start)    */
    char	       *start;		  /* Start of packet		    */
    char	       *text;		  /* Start of text                  */
    char	       *ioptr;		  /* Current position for i/o       */
    char	       dat[ARDP_PTXT_DSZ];/* The data itself incl headers   */
    unsigned long      mbz;		  /* ZERO to catch runaway strings  */
    struct ptext       *previous;         /* Previous element in list       */
    struct ptext       *next;		  /* Next element in linked list    */
};

typedef struct ptext *PTEXT;
typedef struct ptext PTEXT_ST;
#define NOPKT   ((PTEXT) 0)               /* NULL pointer to ptext          */


/* Request structure: maintains information about pending requests          */
struct rreq {
    int			status;		  /* Status of request              */
    unsigned short	cid;		  /* Connection ID - net byte order */
    short		priority;	  /* Priority - host byte order     */
    int			pf_priority;	  /* Priority assigned by pri_func  */
    short		ardp_version;	  /* ARD protocol version           */
    struct ptext	*inpkt;		  /* Packet in process by applic    */
    unsigned short	rcvd_tot;	  /* Total # of packets to receive  */
    struct ptext	*rcvd;		  /* Received packets               */
    unsigned short	rcvd_thru;	  /* Received all packets through # */
    struct ptext	*comp_thru;	  /* Pointer to RCVD_THRUth packet  */
    struct ptext	*outpkt;	  /* Packets not yet sent           */
    unsigned short	trns_tot;	  /* Total # of packets for trns    */
    struct ptext	*trns;		  /* Transmitted packets            */
    unsigned short	prcvd_thru;	  /* Peer's rcvd_thru               */
    struct sockaddr_in	peer;   	  /* Sender/Destination		    */
#define peer_addr       peer.sin_addr	  /* Address in network byte order  */
#define peer_port       peer.sin_port	  /* Port in network byte order     */
    struct timeval	rcvd_time;	  /* Time request was received      */
    struct timeval	svc_start_time;	  /* Time service began on request  */
    struct timeval	timeout;	  /* Initial time to wait for resp  */
    struct timeval	timeout_adj;      /* Adjusted time to wait for resp */
    struct timeval	wait_till;	  /* Time at which timeout expires  */
    unsigned short	retries;	  /* Number of times to retry       */
    unsigned short	retries_rem;	  /* Number of retries remaining    */
    unsigned short	svc_rwait;	  /* Svc suggested tm2wait b4 retry */
    unsigned short	svc_rwait_seq;	  /* Seq # when scv_rwait changed   */
    unsigned short	inf_queue_pos;    /* Service queue pos if available */
    int			inf_sys_time;     /* Expected time til svc complete */
#ifdef PROSPERO
    struct pfs_auth_info *auth_info;      /* Client authentication info     */
#endif /* PROSPERO */
    char		*client_name;     /* Client name string for logging */
    char		*sw_id;		  /* Client software specific ident */
    int		        (*cfunction)();   /* Function to call when done     */
    char		*cfunction_args;  /* Additional args to cfunction   */
    struct rreq		*previous;        /* Previous element in list       */
    struct rreq		*next;		  /* Next element in linked list    */
};

#define S_AD_SZ           sizeof(struct sockaddr_in)

#define PEER_PORT(req)  (ntohs((req)->peer_port)) /* host byte order        */

typedef struct rreq *RREQ;
typedef struct rreq RREQ_ST;
#define NOREQ   ((RREQ) 0)                /* NULL pointer to rreq           */

#define ARDP_STATUS_NOSTART   0
#define ARDP_STATUS_INACTIVE  0
#define ARDP_STATUS_COMPLETE -1
#define ARDP_STATUS_ACTIVE   -2
#define ARDP_STATUS_ACKPEND  -3
#define ARDP_STATUS_GAPS     -4
#define ARDP_STATUS_ABORTED  -5
#define ARDP_STATUS_FREE     -6
#define ARDP_STATUS_FAILED   255

/* These must remain in the range 0-10 for compatibility with Prospero      */
#define ARDP_SUCCESS		0	/* Successful completion of call    */
#define ARDP_PORT_UNKN		1	/* DIRSRV UDP port unknown          */
#define ARDP_UDP_CANT		2	/* Can't open local UDP port        */
#define ARDP_BAD_HOSTNAME	3	/* Can't resolve hostname           */
#define ARDP_NOT_SENT		4	/* Attempt to send message failed   */
#define ARDP_SELECT_FAILED	5	/* Select failed	            */
#define ARDP_BAD_RECV		6	/* Recvfrom failed 	            */
#define ARDP_BAD_VERSION	7       /* bad version # in rdgram protocol */
#define ARDP_BAD_REQ		8	/* Inconsistent request structure   */
#define ARDP_TIMEOUT            9       /* Timed out - retry count exceeded */
#define	ARDP_REFUSED 	       10	/* Connection refused by server     */
#define	ARDP_FAILURE 	       11	/* Unspecified ARDP failure         */
#define ARDP_TOOLONG	       12       /* Buffer too long for packet       */

#define ARDP_PENDING           -1       /* The request is still pending     */
#define ARDP_WAIT_TILL_TO      -1       /* Wait until timeout occurs        */

#define ARDP_A2R_SPLIT       0x00       /* OK to split across packets       */
#define ARDP_A2R_NOSPLITB    0x01       /* Don't split across packets       */
#define ARDP_A2R_NOSPLITL    0x02       /* Don't split lines across packets */
#define ARDP_A2R_NOSPLITBL   0x03       /* NOSPLITB|NOSPLITL                */
#define ARDP_A2R_TAGLENGTH   0x04       /* Include length tag for buffer    */
#define ARDP_A2R_COMPLETE    0x08       /* This is the final packet to add  */

#define ARDP_R_INCOMPLETE    0x00       /* More messages will follow        */
#define ARDP_R_NOSEND        0x02       /* Add to req->trns but don't send  */
#define ARDP_R_COMPLETE      0x08       /* This is the final packet to send */

/* Queuing priorities for requests */
#define	       ARDP_MAX_PRI   32765  /* Maximum user proiority          */
#define	       ARDP_MAX_SPRI  32767  /* Maximum priority for system use */
#define	       ARDP_MIN_PRI  -32765  /* Maximum user proiority          */
#define	       ARDP_MIN_SPRI -32768  /* Maximum priority for system use */

/* LONG_TO_SHORT_NAME is needed for linkers that can't handle long names */
#ifdef LONG_TO_SHORT_NAME
#define ardp_abort                RDABOR
#define ardp_abort_on_int         RDABOI
#define ardp_accept               RDACPT
#define ardp_activeQ              RDACTV
#define ardp_add2req		  RDA2RQ
#define ardp_bind_port            RDBPRT
#define ardp_completeQ            RDCMPQ
#define ardp_def_port_no          RDDPNO
#define ardp_default_retry        RDDFRT
#define ardp_default_timeout      RDDFTO
#define ardp_doneQ                RDDONQ
#define ardp_get_nxt              RDGNXT
#define ardp_headers              RDHDRS
#define ardp_init	          RDINIT
#define ardp_next_cid	          RDNCID
#define ardp_partialQ             RDPRTQ
#define ardp_pendingQ             RDPNDQ
#define ardp_port	          RDPORT
#define ardp_pri_func             RDPRIF
#define ardp_pri_override         RDOVRD
#define ardp_priority             RDPRIO
#define ardp_process_active       RDPACT
#define ardp_prvport              RDPPRT
#define ardp_ptalloc              RDPTAL
#define ardp_ptfree               RDPTFR
#define ardp_ptlfree              RDPTLF
#define ardp_redirect             RDREDR
#define ardp_refuse               RDRFSE
#define ardp_reply                RDREPL
#define ardp_respond              RDRESP
#define ardp_retrieve             RDRETR
#define ardp_rqalloc              RDRQAL
#define ardp_rqfree               RDRQFR
#define ardp_rqlfree              RDRQLF
#define ardp_runQ                 RDRUNQ
#define ardp_rwait                RDRWAI
#define ardp_send                 RDSEND
#define ardp_set_prvport          RDSPPT
#define ardp_set_queuing_policy   RDSQPL
#define ardp_set_retry            RDSETR
#define ardp_snd_pkt              RDSPKT
#define ardp_srvport              RDSPRT
#define ardp_trap_int             RDTINT
#define ardp_update_cfields       RDUPCF
#define ardp_xmit                 RDXMIT
#define ptext_count               PTXCNT
#define ptext_max                 PTXMAX
#define rreq_count                RRQCNT
#define rreq_max                  RRQMAX
#endif /* LONG_TO_SHORT_NAME */

int		ardp_abort(RREQ);
int		ardp_abort_on_int(void);
int		ardp_accept(void);
int		ardp_add2req(RREQ,int,char*,int);
int		ardp_bind_port(char*);
RREQ		ardp_get_nxt(void);
int		ardp_headers(RREQ);
int		ardp_process_active(void);
PTEXT		ardp_ptalloc(void);
void		ardp_ptfree(PTEXT);
void		ardp_ptlfree(PTEXT);
int		ardp_reply(RREQ,int,char*);
int		ardp_respond(RREQ,int);
int		ardp_retrieve(RREQ,int);
RREQ		ardp_rqalloc(void);
void		ardp_rqfree(RREQ);
void		ardp_rqlfree(RREQ);
int		ardp_rwait(RREQ,int,short,int);
int		ardp_send(RREQ,char*,struct sockaddr_in*,int);
int		ardp_set_prvport(int);
int		ardp_set_queuing_policy(int(*pf)(),int);
int		ardp_set_retry(int,int);
int		ardp_snd_pkt(PTEXT,RREQ);
int		ardp_xmit(RREQ,int);
int		ardp_xmit(RREQ,int);

extern	int	ardp_priority;

#endif /* not ARDP_H_INCLUDED */
