/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 */

#include <usc-copyr.h>
#include <pfs.h>
#include "gopher.h"

static GLINK lfree = NULL;
int glink_count = 0;
int glink_max = 0;


/* 
  glalloc(): Allocate and initialize GLINK structure. 
  Signal out_of_memory() on failure. 
*/

GLINK 
glalloc(void)
{
    GLINK	gl;
    if(lfree) {
        gl = lfree;
        lfree = lfree->next;
    }
    else {
        gl = (GLINK) malloc(sizeof(GLINK_ST));
        if (!gl) out_of_memory();
        glink_max++;
    }

    glink_count++;

    /* Initialize and fill in default values */
    gl->type = '0';
    gl->name = NULL;
    gl->host = NULL;
    gl->port = 0;
    gl->selector = NULL;
    gl->previous = NULL;
    gl->next = NULL;
    return gl;
}


void 
glfree(GLINK gl)
{
    if (gl->name) stfree(gl->name);
    if (gl->host) stfree(gl->host);
    if (gl->selector) stfree(gl->selector);
    gl->next = lfree;
    gl->previous = NULL;
    lfree = gl;
    glink_count--;
}

void 
gllfree(GLINK gl)
{
    GLINK nxt;
    while(gl) {
        nxt = gl->next;
        glfree(gl);
        gl = nxt;
    }

}

