/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

/* Seriously mutilated by swa@isi.edu, 9/29/92 -- 9/30/92 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <ardp.h>
#include <pfs.h>
#include <plog.h>
#include <psrv.h>
#include <perrno.h>
#include <pprot.h>
#include <pmachine.h>
#include "dirsrv.h"

/* list_acl.c */

extern ACL	default_acl;
extern ACL	system_acl;
extern ACL	override_acl;
extern ACL      maint_acl;
extern ACL	nullobj_acl;
extern ACL	nullcont_acl;
extern ACL	nulllink_acl;
extern ACL	nulldir_acl;

extern char	*acltypes[];

ACL get_container_acl();

int 
list_acl(RREQ req, char * command, char *next_word, INPUT in, 
         char client_dir[], int dir_magic_no)
{
    optdecl;
    static char 	*t_name = NULL;
    static char	        *t_options = NULL;
    VDIR_ST		dir_st;            /* Directory contents used ... */
    VDIR		dir = &dir_st;     /* by individual lines         */
    int		retval = PSUCCESS;/* Return value from subfunctions */
    ACL		wacl;		  /* Working access control list  */
    int		aclchk;	          /* Cached ACL check             */
    VLINK       clink;            /* For stepping through links   */
    int         tmp;
    OUTPUT_ST   out_st;
    OUTPUT      out = &out_st;
    long        n_magic_no;     /* magic # of link. XXX currently ignored.*/
    

    vdir_init(dir);
    reqtoout(req, out);

    if (!t_name) t_name = stcopy("");
    if (!t_name) out_of_memory();

    /* First arg is options.  All others are optional. */
    /* If a second argument is specified, it is the    */
    /* link for which the ACL is to be returned        */
    /* if the OBJECT option is specified, then args    */
    /* 2-5 identify the object instead of the link.  Object ACLs unimplemented,
       so we currently suppress those arguments. */
    tmp = qsscanf(next_word, "%&'s %&'s %'*s %*d", &t_options, &t_name);
    /* Log and return a better message */
    if (tmp < 0)
        interr_buffer_full();
    if((tmp < 1) || 
       ((tmp < 2) && (!strequal(t_options,"DIRECTORY"))))  {
        creply(req,"ERROR too few arguments\n");
        plog(L_DIR_PERR,req,"Too few arguments: %s", command);
        return PFAILURE;
    }

    if (in_select(in, &n_magic_no))
        return error_reply(req, "LIST-ACL %'s", p_err_string);

    optstart(t_options);
    /* Do we need a better log message? */
    plog(L_DIR_REQUEST,req,"LA %s %s", client_dir,t_name);

    if(opttest("INCLUDE")) {
	if(strequal(t_name,"SYSTEM")) wacl = system_acl;
	else if(strequal(t_name,"DEFAULT")) wacl = default_acl;
	else if(strequal(t_name,"OVERRIDE")) wacl = override_acl;
	else if(strequal(t_name,"MAINTENANCE")) wacl = maint_acl;
        else {
            creplyf(req,"FAILURE NOT-FOUND ACL %'s",t_name);
            plog(L_DIR_ERR,req,"ACL not found: %s", t_name);
            return PFAILURE;
        }
        aclchk = srv_check_acl(wacl,NULL,req,"Y",SCA_MISC,NULL,NULL);
	/* If not authorized, say so */
	if(!aclchk) {
	    creply(req,"FAILURE NOT-AUTHORIZED\n");
	    plog(L_AUTH_ERR,req,"Unauthorized LIST-ACL: %s", t_name);
	    return PFAILURE;
	}
	if(wacl == NULL) retval = reply(req,"ACL NONE '' ''\n");
	else out_acl(out, wacl);
	return(retval);
    }
    else if(opttest("OBJECT")||opttest("CONTAINER")) {
	PFILE		fi = pfalloc();
	int		rsinfo_ret;
	if (!fi) out_of_memory();
	rsinfo_ret = dsrfinfo(t_name,0,fi);

	if(rsinfo_ret == DSRFINFO_FORWARDED) {
	    VLINK fl;               /* List of forwarding pointers */
	    VLINK fp;               /* Current forwarding pointer */
	    fl = fi->forward; fi->forward = NULL;
	    fp = check_fwd(fl,t_name,0);

	    /* Free what we don't need */
	    pffree(fi); fi = NULL;

	    /* Got to location to return forwarded error */
	    forwarded(req, fl, fp, clink->hsoname);
	    return PSUCCESS;
	}

	if(opttest("CONTAINER")) {
	    wacl = get_container_acl(t_name);
	}
	else {
	    wacl = fi->oacl;
	    fi->oacl = NULL;
	}
	pffree(fi); fi = NULL;


        aclchk = srv_check_acl(wacl,NULL,req,"Y",SCA_OBJECT,NULL,NULL);
	/* If not authorized, say so */
	if(!aclchk) {
	    creply(req,"FAILURE NOT-AUTHORIZED\n");
	    plog(L_AUTH_ERR,req,"Unauthorized LIST-ACL: OBJECT %s", t_name);
	    aclfree(wacl);
	    return PFAILURE;
	}

	if(wacl == NULL) {
	    if(opttest("CONTAINER")) out_acl(out, nullcont_acl);
	    else out_acl(out, nullobj_acl);
	}
	else out_acl(out, wacl);
	return(retval);
    }

    retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
    if(retval == DSRFINFO_FORWARDED) {
        dforwarded(req, client_dir, dir_magic_no, dir);
        return PSUCCESS;
    }

    /* If not a directory, say so */
    if(retval == DSRDIR_NOT_A_DIRECTORY) {
        creply(req,"FAILURE NOT-A-DIRECTORY\n");
        plog(L_DIR_ERR,req,"Invalid directory name: %s", client_dir);
        return PFAILURE;
    }

    wacl = NULL;

    if(opttest("LINK")) {
        /* Need to find the link so we can check its ACL */
        clink = dir->links;
        while(clink) {
            if(strequal(clink->name,t_name) && clink->linktype != '-')
                break;
            clink = clink->next;
        }
        if(!clink) {
            clink = dir->ulinks;
            while(clink) {
                if(strcmp(clink->name,t_name) == 0)
                    break;
                clink = clink->next;
            }		 
        }
        if(!clink) {
            creplyf(req,"FAILURE NOT-FOUND LINK %'s",t_name);
            plog(L_DIR_ERR,req,"Link not found: %s %s", client_dir, t_name);
            vdir_freelinks(dir);
            return PFAILURE;
        }
        wacl = clink->acl;
        aclchk = srv_check_acl(clink->acl,dir->dacl,req,"v",SCA_LINK,NULL,NULL);
    } else if(opttest("DIRECTORY")) {
        wacl = dir->dacl;
        aclchk = srv_check_acl(dir->dacl,NULL,req,"V",SCA_DIRECTORY,client_dir,NULL);
    } else {
        creply(req,"ERROR invalid option\n");
        plog(L_DIR_PERR,req,"Invalid option: %s", command);
        /* Free the directory links */
        vdir_freelinks(dir);
        return PFAILURE;
    }

    /* If not authorized, say so */
    if(!aclchk) {
        creply(req,"FAILURE NOT-AUTHORIZED\n");
        plog(L_AUTH_ERR,req,"Unauthorized LIST-ACL: %s %s", client_dir,t_name);
        vdir_freelinks(dir);
        return PFAILURE;
    }

    if(wacl == NULL) {
        if(opttest("LINK")) /* Link default is diracl */
	    out_acl(out, nulllink_acl);
        else {
	    out_acl(out, nulldir_acl);
        }
    } else {
        out_acl(out, wacl);
    }

#ifdef DATABASE_PREFIX          /* Keep database_acl alway set to the most
                           current version.  That way, if the database
                           ACL changes after server startup, you get
                           its most recent incarnation. */
    if(strcmp(client_dir,DATABASE_PREFIX) == 0) {
        aclfree(database_acl);
        database_acl = dir->dacl;
        dir->dacl = NULL;
    } 
#endif		    
    vdir_freelinks(dir);
    return retval;
}                           /* What does this go to? */
