/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <sys/param.h>
#include <syscall.h>
#include <errno.h>


#include <pfs.h>
#include <pcompat.h>

extern int	pfs_enable;
extern int	perrno;

execve(name,argv,envp)
    char *name;
    char *argv[];
    char *envp[];
{
    char		npath[MAXPATHLEN];

    int		tmp;

    tmp = pfs_access(name, npath, sizeof npath, PFA_MAP);

    /* Should figure out what correct error return should be */
    if(tmp) return(-1);

    return(syscall(SYS_execve,npath,argv,envp));
}
