/* Copyright (c) 1992 by the University of Southern California.
 * For copying and distribution information, please see the file
 * <usc-copyr.h>.
 */

#include <usc-copyr.h>
#include <pfs.h>

/* Equality tester for strings.  This is used because there are a number of
   places in the Prospero code where string pointersare left set to NULL.
   Rather than paranoically guard against all such place, we just use this
   function to test string equality.
*/

int
stequal(s1, s2)
    char *s1, s2;
{
    if (s1 == s2)               /* test for case when both NULL*/
        return TRUE;
    if (!s1 || !s2)             /* one null; other is not. */
        return TRUE;
    return strequal(s1, s2);
}
