/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1989     modified 1989-1991
 * modified by bcn 1/19/93  to support new argument conventions for dirsrv
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <stdio.h>
#include <netdb.h>
#include <sys/param.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <pwd.h> 
 
#include <pserver.h>
#include <pprot.h>
#include <pmachine.h>


main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char			*dsargv[10]; /* Args to dirsrv          */
	int			dsargc = 0;  /* Count of args to dirsrv */
	char			prvparg[10]; /* -p%d (%d is file desc)  */
	char			shadowarg[MAXPATHLEN];
	char			datarg[MAXPATHLEN];
	char			aftparg[MAXPATHLEN];

	struct sockaddr_in 	s_in = {AF_INET};
	int			prvport = -1;
	int			ruid,euid;
	struct servent 		*sp;
	struct passwd   	*pw;

	int			one = 1;

	if (argc > 2) {
	    fprintf(stderr,"Usage: %s [full-host-name]\n",argv[0]);
	    exit(1);
	}

	ruid = getuid();
	euid = geteuid();

	/* If root try to bind privileged port before changing uid */
	if((ruid == 0) || (euid == 0)) {
	    if ((sp = getservbyname("prospero", "udp")) == 0) 
		s_in.sin_port = htons((ushort) PROSPERO_PORT);
	    else s_in.sin_port = sp->s_port;

	    if ((prvport = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
		fprintf(stderr, "pstart: Can't open socket\n");

	    setsockopt(prvport, SOL_SOCKET, SO_REUSEADDR, &one, sizeof(one));
	    
	    if (bind(prvport, &s_in, S_AD_SZ) < 0) {
		fprintf(stderr, "pstart: Can not bind privileged port\n");
		close(prvport);
		prvport = -1;
	    }
	}

	/* Find the Prospero UID, so we can setuid if we are root */
	if((pw = getpwnam(PSRV_USER_ID)) == NULL) {
	    fprintf(stderr,"%s: Can't find passwd entry for %s.\n",
		    argv[0],PSRV_USER_ID);
	    exit(1);
	}

	/* Don't allow changes to paths unless running as root or */
	/* already running as prospero                            */
	if((ruid != 0) && (ruid != pw->pw_uid) && 
	   (getenv("PSRV_ROOT") || getenv("PSRV_FSHADOW") || 
	    getenv("PSRV_FSTORAGE") || getenv("PSRV_AFTPDIR") || 
	    getenv("PSRV_AFSDIR") || getenv("PSRV_LOGFILE"))) {
	    fprintf(stderr,"%s: PSRV_* environment variables set but not authorized.\n",argv[0]);
	    exit(1);
	}

	/* Set the uid and gid if necessary */
  	if((ruid != pw->pw_uid) || (euid != pw->pw_uid)) {
	    if(setgid(pw->pw_gid)) {
  		fprintf(stderr,"%s: Can't set gid.\n",argv[0]);
  		exit(1);
  	    }

	    if(setuid(pw->pw_uid)) {
		fprintf(stderr,"%s: Can't set uid.\n",argv[0]);
		exit(1);
	    }
	}

	dsargv[0] = "dirsrv"; dsargc++;

	if(prvport >= 0) {
	    sprintf(prvparg,"-p%d",prvport);
	    dsargv[dsargc++] = prvparg;
	}

#ifdef P_UNDER_UDIR
	sprintf(shadowarg,"-S%s/%s",pw->pw_dir,PSRV_FSHADOW);
	sprintf(datarg,"-T%s/%s",pw->pw_dir,PSRV_FSTORAGE);
	dsargv[dsargc++] = shadowarg;
	dsargv[dsargc++] = datarg;
#endif P_UNDER_UDIR

#ifdef AFTPUSER
	/* Find FTP directory - if error, use AFTPDIRECTORY */
	if((pw = getpwnam(AFTPUSER)) != NULL) 
	    sprintf(aftparg,"-f%s",pw->pw_dir);
	dsargv[dsargc++] = aftparg;
#endif AFTPUSER

	if(argc > 1) {
	    dsargv[argc++] = "-h";	    
	    dsargv[argc++] = argv[1];
	}

	dsargv[dsargc++] = NULL;

	umask(7);

	execv(P_DIRSRV_BINARY,dsargv);

	/* Execl failed */
	exit(1);
    }
