/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <usc-copyr.h>
#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>

static FILTER	lfree = NULL;
/* These are global variables which will be read by dirsrv.c
   Too bad C doesn't have better methods for structuring such global data.  */

int		filter_count = 0;
int		filter_max = 0;

/*
 * flalloc - allocate and initialize FILTER structure
 *
 *    FLALLOC returns a pointer to an initialized structure of type
 *    FILTER.  If it is unable to allocate such a structure, it
 *    signals out_of_memory();
 */
FILTER
flalloc()
{

    FILTER	fil;
    if(lfree) {
        fil = lfree;
        lfree = lfree->next;
    }
    else {
        fil = (FILTER) malloc(sizeof(FILTER_ST));
        if (!fil) out_of_memory();
        filter_max++;
    }

    filter_count++;

    /* Initialize and fill in default values */
#ifdef ALLOCATOR_CONSISTENCY_CHECK
    fil->consistency = INUSE_PATTERN;
#endif
    fil->name = NULL;
    fil->link = NULL;
    fil->type = 0;              /* Illegal value */
    fil->execution_location = 0; /* Neither -- illegal value. */
    fil->pre_or_post = 0;       /* Neither -- illegal value */
    fil->args = NULL;
    fil->previous = NULL;
    fil->next = NULL;
    return(fil);
}

/*
 * flfree - free a FILTER structure
 *
 *    FLFREE takes a pointer to a FILTER structure and adds it to
 *    the free list for later reuse.
 */
flfree(fil)
FILTER	fil;
{
#ifdef ALLOCATOR_CONSISTENCY_CHECK
    assert(fil->consistency == INUSE_PATTERN);
    fil->consistency = FREE_PATTERN;
#endif
    if(fil->name) stfree(fil->name);
    if(fil->link) vlfree(fil->link);
    if(fil->args) tklfree(fil->args);
    fil->next = lfree;
    fil->previous = NULL;
    lfree = fil;
    filter_count--;
}

/*
 * fllfree - free a linked list of FILTER structures.
 *
 *    FLLFREE takes a pointer to a FILTER structure frees it and any linked
 *    FILTER structures.  It is used to free an entrie list of FILTER
 *    structures.
 */
fllfree(fil)
    FILTER	fil;
{
    FILTER	nxt;

    while((fil != NULL) /* && !fil->dontfree */) {
        nxt = fil->next;
        flfree(fil);
        fil = nxt;
    }
}



/*
 * flcopy - allocates a new filter structure and
 *          initializes it with a copy of another 
 *          filter, v.
 *
 *          If r is non-zero, successive filters will be
 *          iteratively copied.
 *
 *          fl-previous will always be null on the first link, and
 *          will be appropriately filled in for iteratively copied links. 
 *
 *          FLCOPY returns a pointer to the new structure of type
 *          FILTER.  If it is unable to allocate such a structure, it
 *          returns NULL.
 *
 *          FLCOPY will recursively copy the link associated with a filter and
 *          its associated attributes. 
 */

FILTER
flcopy(f,r)
    FILTER	f;
    int	r;              /* Currently ignored. */
{
    FILTER	nf;
    FILTER	snf;  /* Start of the chain of new links */
    FILTER	tf;   /* Temporary link pointer          */

    nf = flalloc();
    snf = nf;

copyeach:

    /* Copy f into nf */
#ifdef ALLOCATOR_CONSISTENCY_CHECK
    assert(f->consistency == INUSE_PATTERN);
#endif
    if(f->name) nf->name = stcopyr(f->name,nf->name);
    if(f->link) nf->link = vlcopy(f->link, 1);
    nf->type = f->type;
    nf->execution_location = f->execution_location;
    nf->pre_or_post = f->pre_or_post;
    nf->args = tkcopy(f->args);
    if(r && f->next) {
        f = f->next;
        tf = nf;
        nf = flalloc();
        nf->previous = tf;
        tf->next = nf;
        goto copyeach;
    }

    return(snf);
}

