/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

#include <netdb.h>
#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <pserver.h>
#ifdef SERVER_SUPPORT_V1        /* This entire file exists only so that the
                                   server can support Version 1 of the Prospero
                                   Protocol. */
#include <ardp.h>
#include <pfs.h>
#include <psrv.h>
#include <plog.h>
#include <pprot.h>
#include <perrno.h>

#include <pmachine.h>

#include "dirsrv.h"

/* PPROT.H used to include this definition, but it doesn't any more.  It's now
   moved. */
/* This macro is now officially vestigial.  */

/* Replacement for strtok that doesn't keep state.  Both the variable  */
/* S and the variable S_next must be defined.  To initialize, assign   */
/* the string to be stepped through to S_next, then call get_token on  */
/* S.  The first token will be in S, and S_next will point to the next */
/* token.  Like strtok, this macro does modify the string passed to it */
#ifdef __STDC__
#define get_token(S,C) \
  do { \
    S = S##_next; \
    if(S) { \
     while(*S == C) S++; \
     S##_next = index(S,C); \
     if(S##_next) *(S##_next++) = '\0'; \
     if(!*S) S = NULL; \
    } \
  } while (0)
#else
#define get_token(S,C) \
  do { \
    S = S/**/_next; \
    if(S) { \
     while(*S == C) S++; \
     S/**/_next = index(S,C); \
     if(S/**/_next) *(S/**/_next++) = '\0'; \
     if(!*S) S = NULL; \
    } \
  } while (0)
#endif/*  _STDC__ */

extern int errno;

extern char	*acltypes[];

/* To check for memory leaks */
extern int vlink_count;
extern int pattrib_count;
extern int acl_count;
extern int pfile_count;
extern int rreq_count;
extern int ptext_count;
extern int string_count;
extern int vlink_max;
extern int pattrib_max;
extern int acl_max;
extern int pfile_max;
extern int rreq_max;
extern int ptext_max;
extern int string_max;

static char *quote();
static char	*v1_check_nfs();
static int v1_externalize(VLINK vl);

VLINK	check_fwd();
static	v1_cmd_lookup();
extern char *unquote(), *unquoten();
static TOKEN tokenize(char *);

    
/* link TARGET of SYMBOLIC must be changed to SYM-LINK for V1 protocol. */
#define symlinkify(foo) (((foo)[0] == 'S') ? "SYM-LINK" : (foo))


/* This will be called by dirsrv() to process a Protocol Version 1 format
   packet.  It is old code which can have its internal buffers easily
   over-written, but that's life.   It also won't return all of the information
   that the newer versions of the protocol will.  Tough noogies. */
    
dirsrv_v1(req,command_next)
    RREQ req;
    char *command_next;
    {
	static long 	client_host;

	/* The following are set in one line and used by subsequent */
	/* lines of the same message                                */

	int	client_version = MAX_VERSION;   /* Protocol version nbr   */
	char	auth_type[40];          	/* Type of Authentication */
	char	authent[160];           	/* Authentication data    */
	char	client_id[160];         	/* Authenticated username */
	char	client_dir[MAXPATHLEN]; 	/* Current directory      */
	long	dir_version = -1;       	/* Directory version nbr  */
	long	dir_magic_no = -1;      	/* Directory magic number */
#ifdef ARCHIE
	int	max_list_commands = 5;		/* Max lists in request   */
#endif /* ARCHIE */

	/* The following are used while processing the current line       */

	char		*command;          /* The current line            */
	/* command_next is The next line            */
	int		cmd_code;          /* Operation code              */

	VDIR_ST		dir_st;            /* Directory contents used ... */
	VDIR		dir = &dir_st;     /* by individual lines         */

	PFILE		fi;                /* individual lines            */

	VLINK		fl; 	           /* List of forwarding pointers */
	VLINK		fp; 	           /* The current fp              */
	
	char		*components;	   /* Components to be processed  */
	char		*remcomp;	   /* Remaining components        */
	char		localexp;	   /* OK to exp ul for remcomp    */
	VLINK		uexp;		   /* Current link being expanded */
	char		attribfl;	   /* Send back atribues in list  */
	int		item_count = 0;    /* Count of returned items     */

	/* Temporaries */

	char		dir_type[40];     /* Type or dir name (ASCII)     */
	char		*amarg;           /* Arguments for access method  */
	VLINK		clink;            /* For stepping through links   */
	VLINK		crep;            /* For stepping through replicas*/
	FILTER		cfil;             /* For stepping through filters */
	PATTRIB		ca;		  /* Current Attribute            */

	char		*suffix;	  /* Trailing component(s)        */
	int		rsinfo_ret;       /* Ret Val from dsrfinfo        */
	int		verify_dir;       /* Only verifying the directory */
	int		retval;
	int		tmp;
	int		i;
	int		dsdb_options = 0; 

	int		lpriv;		  /* LPRIV option for CREATE-DIR  */
	ACL		wacl;		  /* Working access control list  */
	int		laclchkl;         /* Cached ACL check             */
	int		daclchkl;         /* Cached ACL check             */
	int		laclchkr;         /* Cached ACL check             */
	int		daclchkr;         /* Cached ACL check             */
	int		aclchk;	          /* Cached ACL check             */
	ACL		nacl;		  /* New ACL entry                */

	/* Temporaries for use by sscanf */
	char	t_ltype;
	char 	t_name[MAX_DIR_LINESIZE];
	char	t_type[MAX_DIR_LINESIZE];
	char 	t_htype[MAX_DIR_LINESIZE];
	char 	t_host[MAX_DIR_LINESIZE];
	char 	t_ntype[MAX_DIR_LINESIZE];
	char 	t_fname[MAX_DIR_LINESIZE];
	char	t_options[MAX_DIR_LINESIZE];
	char 	t_acetype[MAX_DIR_LINESIZE];
	char 	t_atype[MAX_DIR_LINESIZE];
	char 	t_rights[MAX_DIR_LINESIZE];
	char	t_principals[MAX_DIR_LINESIZE];
	int	t_num;
	int	n_options;

	char	insrights[MAX_DIR_LINESIZE];

	char	qatype[MAX_DIR_LINESIZE];
	char	qrights[MAX_DIR_LINESIZE];

        if(req->ardp_version > -1) req->ardp_version = -2;

	vdir_init(dir);

	client_host = req->peer.sin_addr.s_addr;

	*client_dir = '\0';
	strcpy(authent,"NONE");
	strcpy(client_id,"");
	
	get_token(command,'\n');       /* Defined in pprot.h */
	
	while(command) 	{
	    
	    cmd_code = v1_cmd_lookup(command);
	    switch(cmd_code) {
		
	    case STATUS:
		status_count++;
		replyf(req,"Prospero server (%s) %s\n",
                       PFS_RELEASE,hostwport);
		if(fault_count) 
		    replyf(req,"Faults since startup %d\n",fault_count);
		replyf(req,"Requests since startup %d (%d+%d+%d %d+%d+%d %d %d+%d+%d %d %d)\n",
		       req_count, list_count, goi_count, lacl_count, 
		       crlnk_count, crdir_count, crobj_count, dellnk_count, 
		       eli_count, eoi_count, eacl_count, upddir_count,
		       status_count);
		replyf(req,"Started: %s\n",st_time_str);
#ifdef PROSPERO_CONTACT
		replyf(req,"Contact: %s\n",PROSPERO_CONTACT);
#endif PROSPERO_CONTACT
		replyf(req," Memory: %d(%d)vl %d(%d)at %d(%d)acl %d(%d)fi %d(%d)pr %d(%d)pt %d(%d)str\n",
		       vlink_count,vlink_max,pattrib_count,pattrib_max,
		       acl_count,acl_max,pfile_count,pfile_max,rreq_count,
		       rreq_max,ptext_count,ptext_max,
		       string_count,string_max);
#ifndef PSRV_READ_ONLY
		if(*pfsdat) replyf(req,"   Data: %s\n", pfsdat);
#endif PSRV_READ_ONLY
		if(*root) replyf(req,"   Root: %s\n", root);
		if(*aftpdir) replyf(req,"   AFTP: %s\n", aftpdir);
		if(*afsdir) replyf(req,"    AFS: %s\n", afsdir);
		if(db_num_ents > 0) {
		    replyf(req,"     DB:");
		    for(i=0;i<db_num_ents;i++) 
			replyf(req," %s",db_prefixes[i].db_prefix);
		    replyf(req,"\n");
		}
		if(last_error) replyf(req,"  Error: %s\n",last_error);

		plog(L_DIR_PINFO, req, "STATUS Request");
		break;

	    case VERSION:
		tmp = sscanf(command,"VERSION %d",&client_version);
		if(tmp != 1) {
                    replyf(req,"VERSION %d %s\n", MAX_VERSION,PFS_SW_ID);
                } else {
                    if (client_version != 1)
                        creplyf(req,"ERROR Cannot specify two different \
versions at the same time.\n",command);
                    plog(L_DIR_ERR, req, "Received VERSION 1 and VERSION %d \
messages in same Prospero request.", client_version);
                    return PFAILURE;
                }
		break;
		
	    case AUTHENTICATOR: {
		char	auth_type[40];    /* Type of Authentication */ 
		PAUTH patmp;
		
		tmp = sscanf(command,"AUTHENTICATOR %s %s",auth_type,authent);
		if(tmp != 2) {
		    creplyf(req,"ERROR Invalid arguments: %s\n",command);
		    plog(L_DIR_PERR, req,
			 "Invalid AUTHENTICATOR command: %s", command);
		    return(PFAILURE);
		}
		if(strcmp(auth_type,"UNAUTHENTICATED")) {
		    creplyf(req,"ERROR authentication type %s not supported\n",
			   auth_type);
		    plog(L_DIR_ERR,req,"Invalid auth-type %s: %s", 
			 auth_type,command);
		    return(PFAILURE);
		}

		/* This memory freed by rdgram transmit() function. */
		if ((patmp = paalloc()) == NULL)
		    return error_reply(req, "Out of Memory (paalloc())!");

		patmp->next = req->auth_info;
		req->auth_info = patmp;

                strcpy(client_id,authent);
		req->client_name = stcopyr(authent,req->client_name);
                patmp->principals = tkalloc(client_id);
                patmp->ainfo_type = PFSA_UNAUTHENTICATED;

	    }
		break;
		
	    case DIRECTORY:
		dir_version = 0;
		dir_magic_no = 0;
		tmp = sscanf(command,"DIRECTORY %s %s %d %d",
			     dir_type,client_dir,&dir_version,&dir_magic_no);
		
		if(tmp < 2) {
		    creplyf(req,"ERROR Invalid arguments: %s\n",command);
		    plog(L_DIR_PERR,req,
			 "Invalid DIRECTORY command: %s",command);
		    return(PFAILURE);
		}
		
		if(strcmp(dir_type,"ASCII")) {
		    creplyf(req,"ERROR id-type %s not supported\n",dir_type);
		    plog(L_DIR_ERR,req,"Invalid id-type: %s",
			 command);
		    return(PFAILURE);
		}
		
		if(check_handle(client_dir) == FALSE) {
		    creply(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Invalid directory name: %s",client_dir);
		    return(PFAILURE);
		}
		
		break;
		
	    more_comps:
		/* Set the directory for the next component */

		/* At this point, clink contains the link for the next */
		/* directory, and the directory itself is still filled */
		/* in.  We should save away the directory information, */
		/* then free what remains                              */
		dir_version = clink->version;
		dir_magic_no = clink->f_magic_no;

		strcpy(dir_type,clink->hsonametype);
		strcpy(client_dir,clink->hsoname);
		
		if(strcmp(dir_type,"ASCII")) {
		    creplyf(req,"ERROR id-type %s not supported\n",dir_type);
		    plog(L_DIR_ERR,req,"Invalid id-type: %s",
			 command);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		
		if(check_handle(client_dir) == FALSE) {
		    creply(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Invalid directory name: %s",client_dir);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		components = remcomp;

                vdir_freelinks(dir);
		goto continue_list;

	    case LIST: 
		list_count++;
#ifdef ARCHIE
		if(max_list_commands-- <= 0) {
		    creply(req,"FAILURE NOT-AUTHORIZED Too many list commands in a single request\n");
		    plog(L_AUTH_ERR,req,"Too many list commands");
		    return(PFAILURE);
		}
#endif /* ARCHIE */

		tmp = sscanf(command,"LIST %s COMPONENTS %[^\n]",
			     t_options, t_name);

		if(tmp < 2) components = "*";
		else components = t_name;

		/* If no options, parse again */
		if(strcmp(t_options,"COMPONENTS")==0) {
		    tmp = sscanf(command,"LIST COMPONENTS %[^\n]", t_name);
		    if(tmp < 1) components = "*";
		    else components = t_name;
		}

		if(sindex(t_options,"VERIFY")) verify_dir = 1;
		else verify_dir = 0;

#ifndef DONTSUPPORTOLD
		if(strcmp(components,"%#$PRobably_nOn_existaNT$#%")==0) {
		    components = "*";
		    verify_dir = 1;
		}
#endif

		/* If EXPAND specified, remeber that fact */
		if(sindex(t_options,"EXPAND") || sindex(t_options,"LEXPAND")) 
		    localexp = 2;
		else localexp = 0;

		if(sindex(t_options,"ATTRIBUTES")) attribfl = DSRD_ATTRIBUTES;
		else attribfl = 0;

		plog(L_DIR_REQUEST, req, "L%s %s %s",
		     (verify_dir ? "V" : " "), client_dir, components);
		
		/* Here's where we start to resolve additional components */
	    continue_list:
		remcomp = index(components,'/');
		if(remcomp) {
		    *(remcomp++) = '\0';
		    if(!*remcomp) remcomp = NULL;
		}
		uexp = NULL;

		/* If only expanding last component, clear the flag */
		if(localexp == 1) localexp = 0;

		/* If remaining components, expand for this component only */
		if(remcomp && !localexp) localexp = 1;

	    exp_ulink:

		*p_err_string = '\0';

		if(*client_dir != '/') {  /* Database or special prefix */
		    for(i=0;i<db_num_ents;i++) {
			if(strncmp(client_dir,db_prefixes[i].db_prefix,
				   strlen(db_prefixes[i].db_prefix)) == 0) {
                            TOKEN tkl_remcomp; /* tokenlist version of remcomp
                                                  */ 
                            if (uexp) {
                                strcpy(p_err_string,
                                       "SERVER-FAILED This directory must be \
viewed using Version 5 clients.  Please upgrade to Prospero version 5.");
                                retval = PFAILURE;
                                break; /* failed to expand */
                            }
			    if(db_prefixes[i].db_acl && 
			      !srv_check_acl(db_prefixes[i].db_acl,NULL,req,
					     "r",SCA_DIRECTORY,NULL,NULL)) {
				creply(req,"FAILURE NOT-AUTHORIZED\n");
				plog(L_AUTH_ERR,req,
				     "Unauthorized database request: %s %s",
				     client_dir,components); 
				return(PFAILURE);
			    }
			    /* This could take a while */
			    ardp_rwait(req,180,0,0); 
			    if(verify_dir) dsdb_options |= DSDB_VERIFY;
                            tkl_remcomp = p__slashpath2tkl(remcomp);
			    retval = db_prefixes[i].db_function(req,client_dir,
					 &components,&tkl_remcomp,dir,
                                          dsdb_options, "#INTERESTING",NULL);
                            p__tkl_back_2slashpath(tkl_remcomp, remcomp);
			    break;
			}
		    }
		} 
		else retval=dsrdir(client_dir,dir_magic_no,dir,uexp,attribfl);

                if (retval == DSRFINFO_FORWARDED) {
                    if (remcomp && *remcomp) {
                        fl = dir->f_info->forward; dir->f_info->forward = NULL;
                        fp = check_fwd(fl,client_dir,dir_magic_no);
                        vdir_freelinks(dir);
                        if(fp) {
                            replyf(req,"LINK L DIRECTORY %s %s %s %s %s %d %d\n",
                                   quote(components),
                                   fp->hosttype,fp->host,fp->hsonametype,
                                   fp->hsoname, fp->version,fp->f_magic_no);
                            replyf(req, "UNRESOLVED %s/%s\n", components,
                                   remcomp); 
                        }
                        else replyf(req,"FORWARDED\n");
                        vllfree(fl);

                        break;
                    } else {
                        goto dforwarded;
                    }
                }
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creply(req,"FAILURE NOT-A-DIRECTORY\n");
		    return(PFAILURE);
		}

		/* If some other failure, say so */
		if(retval == DIRSRV_NOT_AUTHORIZED) {
		    if(*p_err_string) 
			creplyf(req,"FAILURE NOT-AUTHORIZED %s\n",p_err_string);
		    else creplyf(req,"FAILURE NOT-AUTHORIZED\n");

		    return(PFAILURE);
		}

		/* If some other failure, say so */
		if(retval) {
		    creplyf(req,"FAILURE SERVER-FAILED\n");
		    return(PFAILURE);
		}

		/* Cache the default answers for ACL checks */
		daclchkl = srv_check_acl(dir->dacl,NULL,req,"l",
					 SCA_DIRECTORY,NULL,NULL);
		daclchkr = srv_check_acl(dir->dacl,NULL,req,"r",
					 SCA_DIRECTORY, NULL,NULL);

		/* Here we must send back the links, excluding those that do */
		/* not match the component name. For each link, we must also */
		/* send back any replicas or links with conflicting names    */
		clink = dir->links;
		while(clink) {
		  crep = clink;
		  while(crep) {
		    /* If ->expanded set means we already returned it */
		    if(crep->expanded) {
			crep = crep->next;
			continue;
		    }
		    /* Check individual ACL only if necessary */
		    laclchkl = daclchkl; laclchkr = daclchkr;
		    if(crep->acl) {
			laclchkl = srv_check_acl(crep->acl,dir->dacl,req,"l",
						 SCA_LINK,NULL,NULL);
			laclchkr = srv_check_acl(crep->acl,dir->dacl,req,"r",
						 SCA_LINK,NULL,NULL);
		    }
		    if(!verify_dir && wcmatch(crep->name,components) &&
		       (laclchkl || (laclchkr && 
				     (strcmp(crep->name,components)==0)))) {
			if(laclchkr) {
			    if(remcomp && !strcmp(crep->host,hostwport) &&
			       !(crep->filters) && !item_count) {
				/* If components remain on this host    */
				/* don't reply, but continue searching  */
				goto more_comps;
			    }
                            if(*crep->target != 'E' 
                               || v1_externalize(crep) == PSUCCESS) {
                                /* Only display this link if it can be
                                   converted to V1 EXTERNAL format. */
                                replyf(req,"LINK L %s %s %s %s %s %s %d %d\n",
                                       symlinkify(crep->target), 
                                       quote(crep->name),
                                       crep->hosttype, crep->host,
                                       crep->hsonametype, crep->hsoname,
                                       crep->version,crep->f_magic_no);
                                item_count++;
                            }
			}
		        else {
			    replyf(req,"LINK L NULL %s NULL NULL NULL NULL 0 0\n",
				   quote(crep->name));
                            item_count++;
			}
			/* Using ->expanded to indicate returned */
			crep->expanded = TRUE;
			/* If link attributes are to be returned, do so */
			/* For now, only link attributes returned       */
			ca = crep->lattrib;
			while(ca && attribfl) {
			 /* For now return all attributes. To be done: */
			 /* return only those requested                */
                            TOKEN tk;
                            if(ca->avtype == ATR_SEQUENCE 
                               && ca->value.sequence
                               /* skip access-method attribute, since it's
                                  not used. */
                               && !strequal(ca->aname, "ACCESS-METHOD")) {
                                replyf(req,"LINK-INFO %s %s ASCII",
                                        ((ca->precedence==ATR_PREC_LINK) ? "LINK":
                                         ((ca->precedence==ATR_PREC_REPLACE)? "REPLACEMENT":
                                          ((ca->precedence==ATR_PREC_ADD) ? "ADDITIONAL":
                                           "CACHED"))),
                                        ca->aname);
                                for (tk = ca->value.sequence; tk; tk = tk->next)
                                    replyf(req, " %s", tk->token);
                                reply(req, "\n");
                            }
                            ca = ca->next;
                        }

#if 0                           /* We don't need to suppor this for backwards
                                   compatability.  */
			/* if there are any filters, send them back too */ 
			cfil = crep->filters;
			while(cfil && laclchkr) {
                            filter_reply(req, cfil, 0);
			    cfil = cfil->next;
			}
#endif
		    }
		    /* Replicas are linked through next, not replicas */
		    /* But the primary link is linked to the replica  */
		    /* list through replicas                          */
		    if(crep == clink) crep = crep->replicas;
		    else crep = crep->next;
		  }
		  clink = clink->next;
		}
		/* here we must send back the unexpanded union links */
		clink = dir->ulinks;
		while(clink && !verify_dir) {
		    if(!clink->expanded &&
		       srv_check_acl(clink->acl,dir->dacl,req,"r",
				     SCA_LINK,NULL,NULL)) {
			if(localexp && !(clink->filters) &&
			   !strcmp(clink->host,hostwport)) {
			    /* Set the directory for the next component   */
			    /* At this point, clink contains the link     */
			    /* for the next directory                     */
			    dir_version = clink->version;
			    dir_magic_no = clink->f_magic_no;

			    strcpy(dir_type,clink->hsonametype);
			    strcpy(client_dir,clink->hsoname);
		
			    if(strcmp(dir_type,"ASCII")) {
				creplyf(req,"ERROR id-type %s not supported\n",
				       dir_type);
				plog(L_DIR_ERR,req,
				     "Invalid id-type: %s", command);
                                vdir_freelinks(dir);
				return(PFAILURE);
			    }
		
			    if(check_handle(client_dir) == FALSE) {
				creplyf(req,"FAILURE NOT-AUTHORIZED\n");
				plog(L_AUTH_ERR,req,
				     "Invalid directory name: %s",client_dir);
                                vdir_freelinks(dir);
				return(PFAILURE);
			    }
			    clink->expanded = TRUE;
			    uexp = clink;
			    goto exp_ulink;
			}
			/* Don't do any more expanding */
			localexp = 0;
                        /* Union links; don't need to v1_externalize. */
			replyf(req,"LINK %c %s %s %s %s %s %s %d %d\n",
			       clink->linktype,
			       symlinkify(clink->target), quote(clink->name),
			       clink->hosttype, clink->host,
			       clink->hsonametype,clink->hsoname,
			       clink->version,clink->f_magic_no);
			item_count++;
			/* if there are any filters */
		    }
		    clink = clink->next;
		}
		
		/* If none, match, say so */
		if(!item_count)
		    replyf(req,"NONE-FOUND\n");
		/* Otherwise, if components remain say so */
		else if(remcomp && *remcomp) 
		    replyf(req,"UNRESOLVED %s\n",remcomp);

                vdir_freelinks(dir);
		break;
		
	    case LIST_ACL: 
		lacl_count++;
		
		*t_name = '\0';

		/* First arg is options.  All others are optional. */
		/* If a second argument is specified, it is the    */
		/* link for which the ACL is to be returned        */
		/* if the OBJECT option is specified, then args    */
		/* 2-5 identify the object instead of the link     */
		tmp = sscanf(command,"LIST-ACL %s %s %*s %*d %*d",
			     t_options, t_name);
		
		/* Log and return a better message */
		if((tmp < 1) || 
		   ((tmp < 2) && (strcmp(t_options,"DIRECTORY") != 0)))  {
		    creplyf(req,"ERROR too few arguments\n");
		    plog(L_DIR_PERR,req,"Too few arguments: %s",
			 command);
		    return(PFAILURE);
		}
		
		/* Do we need a better log message */
		plog(L_DIR_REQUEST,req,"LA %s %s",
		     client_dir,t_name);

		retval = dsrdir(client_dir,dir_magic_no,dir,NULL, 0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req,
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		wacl = NULL;

		/* Only LINK and DIRECTORY are presently implemented */
		if(sindex(t_options,"LINK")) {
		    /* Need to find the link so we can check its ACL */
		    clink = dir->links;
		    while(clink) {
			if(strcmp(clink->name,t_name) == 0 
                           && clink->linktype != '-')
			    break;
			clink = clink->next;
		    }
		    if(!clink) {
			clink = dir->ulinks;
			while(clink) {
			    if(strcmp(clink->name,t_name) == 0)
				break;
			    clink = clink->next;
			}		 
		    }
		    if(!clink) {
			creplyf(req,"FAILURE NOT-FOUND LINK %s\n",t_name);
			plog(L_DIR_ERR,req,"Link not found: %s %s",
			     client_dir, t_name);
                        vdir_freelinks(dir);
			return(PFAILURE);
		    }
		    wacl = clink->acl;
		    aclchk = srv_check_acl(clink->acl,dir->dacl,req,"v",
					   SCA_LINK,NULL,NULL);
		}
		else if(sindex(t_options,"DIRECTORY")) {
		    wacl = dir->dacl;
		    aclchk = srv_check_acl(dir->dacl,NULL,req,"V",
					   SCA_DIRECTORY,NULL,NULL);
		}
		else {
		    creplyf(req,"ERROR invalid option\n");
		    plog(L_DIR_PERR,req,"Invalid option: %s",
			 command);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		/* If not authorized, say so */
		if(!aclchk) {
		    creplyf(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Unauthorized LIST-ACL: %s %s",client_dir,t_name); 
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		if(wacl == NULL) {
		    if(sindex(t_options,"LINK")) /* Link default is diracl */
			replyf(req,"ACL DIRECTORY '' '' ''\n");
		    else {
			replyf(req,"ACL DEFAULT '' '' ''\n");
			replyf(req,"ACL SYSTEM '' '' ''\n");
		    }
		}
		else while (wacl) {
                    TOKEN pr;
		    strcpy(qatype,quote(wacl->atype));
		    strcpy(qrights,quote(wacl->rights));
		    replyf(req,"ACL %s %s %s '", acltypes[wacl->acetype],
                            qatype, qrights);
                    if (pr = wacl->principals) {
                        for (;; pr = pr->next) {
                            replyf(req, wacl->principals->token);
                            if (!pr->next)
                                break;
                            reply(req, " ");
                        }
                    }
                    reply(req, "'\n");
		    wacl = wacl->next;
		}
		
                vdir_freelinks(dir);
		break;

#ifndef PSRV_READ_ONLY
	    case UPDATE: 
		upddir_count++;
		components = sindex(command,"COMPONENTS");
		
		if(!components || (strlen(components) < 12)) components = "*";
		else components += 11;
		
		plog(L_DIR_UPDATE, req, "U %s %s", client_dir, components);
		
		retval = dsrdir(client_dir,dir_magic_no,dir,NULL, 0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req, 
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		/* Here we must check for forwarding of each link and */
		/* update it to reflect the new target                */
		clink = dir->links;
		while(clink) {
		    if(wcmatch(clink->name,components)) {
			/* Check for forwarding */
			if(retrieve_fp(clink) == PSUCCESS) item_count++;
			
			/* If filters, check them too */
			cfil = clink->filters;
			while(cfil) {
			    if(retrieve_fp(cfil) == PSUCCESS) item_count++;
			    cfil = cfil->next;
			}
		    }
		    clink = clink->next;
		}
		
		/* here we must process the union, */
		/* replica and propagate links     */
		clink = dir->ulinks;
		while(clink) {
		    if(wcmatch(clink->name,components)) {
			/* Check for forwarding */
			if(retrieve_fp(clink) == PSUCCESS) item_count++;
			
			/* If filters, check them too ***/
			cfil = clink->filters;
			while(cfil) {
			    if(retrieve_fp(cfil) == PSUCCESS) item_count++;
			    cfil = cfil->next;
			}
		    }
		    clink = clink->next;
		}
		
		retval = 0;
		if(item_count) retval = dswdir(client_dir,dir);
		
		/* Indicate how many updated */
		if(retval) replyf(req,"FAILED to UPDATE %d links\n",item_count);
		else replyf(req,"UPDATED %d links\n",item_count);
		
                vdir_freelinks(dir);
		break;
		
	    case CREATE_LINK: 
		crlnk_count++;
		clink = vlalloc();
		
		tmp = sscanf(command,"CREATE-LINK %c %s %s %s %s %s %s %d %d",
			     &t_ltype,t_name,t_type,t_htype,t_host,
			     t_ntype,t_fname,
			     &(clink->version),&(clink->f_magic_no));
		
		/* Log and return a better message */
		if(tmp < 7) {
		    creplyf(req,"ERROR too few arguments\n");
		    plog(L_DIR_PERR, req,
			 "Too few arguments: %s", command);
		    return(PFAILURE);
		}
		
		if (t_ltype == 'U') clink->linktype = 'U';
		if (t_ltype == 'I') clink->linktype = 'I';
		
		clink->name = stcopyr(unquote(t_name),clink->name);
		clink->target = stcopyr(t_type,clink->target);
		clink->hosttype = stcopyr(t_htype,clink->hosttype);
		clink->host = stcopyr(t_host,clink->host);
		clink->hsonametype = stcopyr(t_ntype,clink->hsonametype);
		clink->hsoname = stcopyr(t_fname,clink->hsoname);
		
		/* Do we need a better log message */
		plog(L_DIR_UPDATE, req,
		     "CL %s %c %s %s %s %s %s %s", client_dir,
		     clink->linktype, clink->name, clink->target,
                     clink->hosttype, clink->host, clink->hsonametype,
                     clink->hsoname);
                if (convert_v1_ltype(t_type, clink))
                    return error_reply(req, "External links of the form %'s are not understood.", t_type);
                
		retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req,
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		/* If not authorized, say so */
		if(!srv_check_acl(dir->dacl,NULL,req,"I",
				  SCA_DIRECTORY,NULL,NULL)) {
		    creplyf(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR, req,
			 "Unauthorized CREATE-LINK: %s %s",client_dir,
			 components); 
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		    
		/* Make sure creator has all rights to link */
		if(!srv_check_acl(dir->dacl,NULL,req,"alrmd",
				  SCA_DIRECTORY,NULL,NULL)) {
		    /* If not, grant full access */
		    nacl = acalloc();
		    nacl->acetype = ACL_ASRTHOST;
		    nacl->rights = stcopyr("alrmd",nacl->rights);
		    nacl->principals = tkcopy(req->auth_info->principals);
		    change_acl(&(clink->acl),nacl,req,MACL_ADD|MACL_LINK,dir->dacl);
		}

		retval = vl_insert(clink,dir,VLI_NOCONFLICT);
		if((retval == VL_INSERT_ALREADY_THERE) ||
		   (retval == UL_INSERT_ALREADY_THERE))    {
		    creplyf(req,"FAILURE ALREADY-EXISTS %s\n",clink->name);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		else if(retval == VL_INSERT_CONFLICT) {
		    creplyf(req,"FAILURE NAME-CONFLICT %s\n",clink->name);
		    plog(L_DIR_ERR, req,
			 "Conflicting link already exists: %s %s", client_dir, clink->name);
		    /* Free the directory links */
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		
		if(!retval) retval = dswdir(client_dir,dir);
		
		/* if successfull say so (need to clean this up) */
		if(!retval)
		    replyf(req,"SUCCESS\n");
		else replyf(req,"FAILURE\n");
		
                vdir_freelinks(dir);
		break;

	    case MODIFY_ACL:
		eacl_count++;
		
		*t_name = '\0';

		tmp = sscanf(command,"MODIFY-ACL %s %s %s %s %s %[^\n]",
			     t_options, t_name, t_acetype, t_atype,
			     t_rights, t_principals);
		
		/* Log and return a better message */
		if(tmp < 6) {
		    creplyf(req,"ERROR too few arguments\n");
		    plog(L_DIR_PERR, req, "Too few arguments: %s",
			 command);
		    return(PFAILURE);
		}
		
		/* Do we need a better log message */
		plog(L_DIR_UPDATE,req,"MA %s %s %s %s %s %s %s",
		     client_dir,t_name,t_options,t_acetype,t_atype,t_rights,
		     t_principals);

		strcpy(t_name,unquote(t_name));

		nacl = acalloc();

		for(nacl->acetype = 0;acltypes[nacl->acetype];(nacl->acetype)++) {
		    if(strcmp(acltypes[nacl->acetype],t_acetype)==0)
			break;
		}
		if(acltypes[nacl->acetype] == NULL) nacl->acetype = 0;

		nacl->atype = stcopyr(unquoten(t_atype),nacl->atype);
		nacl->rights = stcopyr(unquoten(t_rights),nacl->rights);
                nacl->principals = tokenize(unquote(t_principals));
		retval = dsrdir(client_dir,dir_magic_no,dir,NULL, 0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;

		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req,
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		
		n_options = 0;

		/* Parse the options */
		if(sindex(t_options,"NOSYSTEM")!=NULL) n_options|=MACL_NOSYSTEM;
		if(sindex(t_options,"NOSELF")!=NULL) n_options|=MACL_NOSELF;
		if(sindex(t_options,"DEFAULT")!=NULL) n_options|=MACL_DEFAULT;
		if(sindex(t_options,"SET") != NULL) n_options |= MACL_SET;
		if(sindex(t_options,"INSERT")!=NULL) n_options|=MACL_INSERT;
		if(sindex(t_options,"DELETE")!=NULL) n_options|=MACL_DELETE;
		if(sindex(t_options,"ADD")!=NULL) n_options|=MACL_ADD;
		if(sindex(t_options,"SUBTRACT")!=NULL) n_options|=MACL_SUBTRACT;
		if(sindex(t_options,"LINK")!=NULL) n_options|=MACL_LINK;
		if(sindex(t_options,"DIRECTORY")!=NULL) n_options|=MACL_DIRECTORY;
		if(sindex(t_options,"OBJECT")!=NULL) n_options|=MACL_OBJECT;
		if(sindex(t_options,"INCLUDE")!=NULL) n_options|=MACL_INCLUDE;

		wacl = dir->dacl;
		if(!((n_options&MACL_OTYPE)^MACL_LINK)) {
		    /* Need to find the link so we can change its ACL */
		    clink = dir->links;
		    while(clink) {
			if(strcmp(clink->name,t_name) == 0 && clink->linktype
                           != '-')
			    break;
			clink = clink->next;
		    }
		    if(!clink) {
			clink = dir->ulinks;
			while(clink) {
			    if(strcmp(clink->name,t_name) == 0)
				break;
			    clink = clink->next;
			}		 
		    }
		    if(!clink) {
			creplyf(req,"FAILURE NOT-FOUND LINK %s\n",t_name);
			plog(L_DIR_ERR,req,"Link not found: %s %s",
			     client_dir, t_name);
                        vdir_freelinks(dir);
			return(PFAILURE);
		    }
		    if(clink->acl) wacl = clink->acl;
		    /* Check and update link ACL */
		    aclchk = srv_check_acl(clink->acl,dir->dacl,req,"a",
					   SCA_LINK,NULL,NULL);
		    if(!aclchk && nacl->rights && *(nacl->rights) &&
		       (!((n_options&MACL_OP)^MACL_ADD) ||
			!((n_options&MACL_OP)^MACL_INSERT) ||
			!((n_options&MACL_OP)^MACL_SUBTRACT) ||
			!((n_options&MACL_OP)^MACL_DELETE))) {
			if(!((n_options&MACL_OP)^MACL_ADD) ||
			   !((n_options&MACL_OP)^MACL_INSERT))
			    *insrights = ']';
			else *insrights = '[';
			strcpy(insrights+1,nacl->rights);
			aclchk = srv_check_acl(clink->acl,dir->dacl,req,insrights,
					   SCA_LINK,NULL,NULL);
			/* Don't use this to upgrade [ to a */
			if(aclchk) n_options |= MACL_NOSELF;
		    }
		    /* If not authorized, say so */
		    if(!aclchk) {
			creplyf(req,"FAILURE NOT-AUTHORIZED\n");
			plog(L_AUTH_ERR,req,
			     "Unauthorized LIST-ACL: %s %s",client_dir,t_name); 
                        vdir_freelinks(dir);
			return(PFAILURE);
		    }
 		    retval = change_acl(&(clink->acl),nacl,req,n_options,dir->dacl);
		    /* if native and successful, native no more */
		    if((clink->linktype == 'N') && !retval) clink->linktype = 'L';
		}
		else if(!((n_options&MACL_OTYPE)^MACL_DIRECTORY)) {
		    /* Check and update directory ACL */
		    aclchk = srv_check_acl(dir->dacl,NULL,req,"A",
					   SCA_DIRECTORY,NULL,NULL);
		    if(!aclchk && nacl->rights && *(nacl->rights) &&
		       (!((n_options&MACL_OP)^MACL_ADD) ||
			!((n_options&MACL_OP)^MACL_INSERT) ||
			!((n_options&MACL_OP)^MACL_SUBTRACT) ||
			!((n_options&MACL_OP)^MACL_DELETE))) {
			if(!((n_options&MACL_OP)^MACL_ADD) ||
			   !((n_options&MACL_OP)^MACL_INSERT))
			    *insrights = '>';
			else *insrights = '<';
			strcpy(insrights+1,nacl->rights);
			aclchk = srv_check_acl(dir->dacl,NULL,req,insrights,
					       SCA_DIRECTORY,NULL,NULL);
			/* Don't use this to upgrade < to a */
			if(aclchk) n_options |= MACL_NOSELF;
		    }
		    /* If not authorized, say so */
		    if(!aclchk) {
			creplyf(req,"FAILURE NOT-AUTHORIZED\n");
			plog(L_AUTH_ERR,req,
			     "Unauthorized LIST-ACL: %s %s",client_dir,t_name); 
                        vdir_freelinks(dir);
			return(PFAILURE);
		    }
		    retval = change_acl(&(dir->dacl),nacl,req,n_options,dir->dacl);
		}
		else {
		    creplyf(req,"ERROR invalid option\n");
		    plog(L_DIR_PERR,req,"Invalid option: %s",
			 command);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		/* if unsuccessfull say so (need to clean this up) */
		if(retval) replyf(req,"FAILURE NOT-FOUND ACL\n");
		else { /* Otherwise write the directory and indicate success */
		    retval = dswdir(client_dir,dir);
		    if(retval) replyf(req,"FAILURE\n");
		    else replyf(req,"SUCCESS\n");
		}

                vdir_freelinks(dir);
		break;

	    case MODIFY_LINK: 
		eli_count++;
                replyf(req, "FAILURE SERVER-FAILED Unimplemented Command -- \
MODIFY-LINK.  (Try running V5 clients!)\n");
		break;

	    case CREATE_DIRECTORY: 
		crdir_count++;
		clink = vlalloc();
		
		/* still have to read the remainder of the attributes */
		tmp = sscanf(command,"CREATE-DIRECTORY %s %s",
			     t_options,t_name);
		
		/* Log and return a better message */
		if(tmp < 2) {
		    creplyf(req,"ERROR too few arguments\n");
		    plog(L_DIR_PERR,req,"Too few arguments: %s",
			 command);
		    return(PFAILURE);
		}

		/* For now, VIRTRUAL option must be specified */
		if(sindex(t_options,"VIRTUAL") == NULL) {
		    creplyf(req,"ERROR only VIRTUAL directories implemented\n");
		    plog(L_DIR_PERR,req,"Tried to create non-VIRTUAL directory: %s",
			 command);
		    return(PFAILURE);
		}
		
		if(sindex(t_options,"LPRIV")) lpriv = 1;
		else lpriv = 0;

		clink->name = stcopyr(t_name,clink->name);
		clink->target = stcopyr("DIRECTORY",clink->target);
		clink->host = stcopyr(hostwport,clink->host);
		
		strcpy(t_fname,client_dir);
		strcat(t_fname,"/");
		strcat(t_fname,t_name);
		
		clink->hsoname = stcopyr(t_fname,clink->hsoname);
		
		/* Do we need a better log message */
		plog(L_DIR_UPDATE,req,"MKD %s %s",
		     client_dir, clink->name);
		
		retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req,
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		/* If not authorized, say so */
		if(!srv_check_acl(dir->dacl,NULL,req,"I",
				  SCA_DIRECTORY,NULL,NULL)) {
		    creplyf(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Unauthorized CREATE-DIRECTORY: %s %s",client_dir,
			 components); 
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		retval = vl_insert(clink,dir,VLI_NOCONFLICT);
		if(retval == VL_INSERT_ALREADY_THERE) {
		    creplyf(req,"FAILURE ALREADY-EXISTS %s\n",clink->name);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		else if(retval == VL_INSERT_CONFLICT) {
		    creplyf(req,"FAILURE NAME-CONFLICT %s\n",clink->name);
		    plog(L_DIR_ERR,req,
			 "Conflicting link already exists: %s %s",client_dir,clink->name);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		if(!retval) retval = dswdir(client_dir,dir);

		/* We should check if the new directory already */
		/* exists and if so pick a new name for the     */
		/* physical instantiation ****                  */

		/* Free the directory links, but leave ACL.  This saves the
                   ACL for the child directory. */
		vllfree(dir->links); dir->links = NULL;
		vllfree(dir->ulinks); dir->ulinks = NULL;
		dir->inc_native = VDIN_NONATIVE;
		
		/* Add creator to the ACL */
		if(!lpriv || (!srv_check_acl(dir->dacl,NULL,req,"AIlr",
					     SCA_DIRECTORY,NULL,NULL))) {
		    nacl = acalloc();
		    nacl->acetype = ACL_ASRTHOST;
		    if(lpriv) nacl->rights = stcopyr("AIlr",nacl->rights);
		    else nacl->rights = stcopyr("ALRMDI",nacl->rights);
		    nacl->principals = tkcopy(req->auth_info->principals);
		    change_acl(&(dir->dacl),nacl,req,MACL_ADD|MACL_DIRECTORY,dir->dacl);
		}

		if(!retval) retval = dswdir(t_fname,dir);
		
		/* Free the ACL */
		aclfree(dir->dacl); dir->dacl = NULL;

		/* if successfull say so (need to clean this up) */
		if(!retval)
		    replyf(req,"SUCCESS\n");
		else replyf(req,"FAILURE\n");
		
		break;
		
	    case DELETE_LINK: 
		dellnk_count++;
		t_num = 1;
		
		tmp = sscanf(command,"DELETE-LINK VLINK %s NUMBER %d",
			     t_name,&t_num);
		
		/* Log and return a better message */
		if(tmp < 1) {
		    creplyf(req,"ERROR too few arguments\n");
		    plog(L_DIR_PERR,req,"Too few arguments: %s",
			 command);
		    return(PFAILURE);
		}
		
		/* Do we need a better log message */
		plog(L_DIR_UPDATE,req,"RM %s %s # %d",
		     client_dir,t_name,t_num);
		
		retval = dsrdir(client_dir,dir_magic_no,dir,NULL,0);
		if(retval == DSRFINFO_FORWARDED) goto dforwarded;
		
		/* If not a directory, say so */
		if(retval == DSRDIR_NOT_A_DIRECTORY) {
		    creplyf(req,"FAILURE NOT-A-DIRECTORY\n");
		    plog(L_DIR_ERR, req,
			 "Invalid directory name: %s", client_dir);
		    return(PFAILURE);
		}
		
		/* Need to find the link so we can check its ACL */
		clink = dir->links;
		while(clink) {
		    if(strcmp(clink->name,t_name) == 0 && clink->linktype != '-')
			break;
		    clink = clink->next;
		}
		if(!clink) {
		    clink = dir->ulinks;
		    while(clink) {
			if(strcmp(clink->name,t_name) == 0)
			    break;
			clink = clink->next;
		    }		 
		}
		if(clink) wacl = clink->acl;
		else wacl = NULL;

		/* If not authorized, say so */
		if(!srv_check_acl(wacl,dir->dacl,req,"d",SCA_LINK,NULL,NULL)) {
		    creplyf(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Unauthorized DELETE-LINK: %s %s",client_dir,
			 t_name); 
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}

		clink = vl_delete(dir->links,t_name,t_num);
		if(!perrno) dir->links = clink;

		else {
		    clink = vl_delete(dir->ulinks,t_name,t_num);
		    if(!perrno) dir->ulinks = clink;
		}
		
		if(perrno) {
		    creplyf(req,"FAILURE NOT-FOUND FILE %s\n",t_name);
		    plog(L_DIR_ERR,req,"Link not found: %s %s",
			 client_dir, t_name);
                    vdir_freelinks(dir);
		    return(PFAILURE);
		}
		
		retval = dswdir(client_dir,dir);
		vdir_freelinks(dir);
		/* if successfull say so (need to clean this up) */
		if(!retval)
		    replyf(req,"SUCCESS\n");
		else replyf(req,"FAILURE\n");
		
		break;
#endif
		
	    case GET_OBJECT_INFO:	
		goi_count++;
		t_num = 0;
		item_count = 0;
		
		/* still have to read the remainder of the attributes */
		tmp = sscanf(command,"GET-OBJECT-INFO %s ID %s %s %*d %d",
			     t_name,t_ntype,t_fname,&t_num);
		
		/* Log and return a better message */
		if(tmp < 3) {
		    creplyf(req,"ERROR wrong number of arguments\n");
		    plog(L_DIR_PERR,req,"Too few arguments: %s", 
			 command);
		    return(PFAILURE);
		}
		
		/* Do we need a better log message */
		plog(L_DIR_REQUEST, req, "GOI %s %s",
		     t_name,t_fname);
		
		if(check_handle(t_fname) == FALSE) {
		    creplyf(req,"FAILURE NOT-AUTHORIZED\n");
		    plog(L_AUTH_ERR,req,
			 "Invalid directory name: %s",t_fname);
		    return(PFAILURE);
		}

		clink = vlalloc();
		fi = pfalloc();
		
		clink->hsonametype = stcopyr(t_ntype,clink->hsonametype);
		clink->hsoname = stcopyr(t_fname,clink->hsoname);
		clink->f_magic_no = t_num;
		
		rsinfo_ret = dsrfinfo(clink->hsoname,clink->f_magic_no,fi);
		
		if(strcmp(t_name,"FORWARDING-POINTER") == 0) {
		    if(rsinfo_ret == DSRFINFO_FORWARDED) {
			if(fl = check_fwd(fi->forward,clink->hsoname,
					  clink->f_magic_no)) {
			    replyf(req,"OBJECT-INFO FORWARDING-POINTER LINK L FP %s %s %s %s %s %d %d\n",
				   quote(clink->name),
				   fl->hosttype, fl->host,
				   fl->hsonametype, fl->hsoname,
				   fl->version,fl->f_magic_no);
			    item_count++;
			}
		    }
		    
		    else if((clink->f_magic_no == 0) && (fi->f_magic_no != 0)) {
			replyf(req,"OBJECT-INFO FORWARDING-POINTER LINK L FP %s %s %s %s %s %d %d\n",
			       quote(clink->name),
			       clink->hosttype, hostwport,
			       clink->hsonametype, clink->hsoname,
			       clink->version,fi->f_magic_no);
			item_count++;
		    }
		}
		else if(rsinfo_ret == DSRFINFO_FORWARDED) {
		    fl = fi->forward; fi->forward = NULL;
		    fp = check_fwd(fl,clink->hsoname,clink->f_magic_no);
		    
		    /* Free what we don't need */
		    pffree(fi); fi = NULL;
		    
		    /* Got to location to return forwarded error */
		    goto forwarded;
		}
		else if(strcmp(t_name,"ACCESS-METHODS") == 0) {
		    plog(L_DIR_PWARN,req,
			 "Old format GOI AM");
#ifdef NFS_EXPORT
		    amarg = v1_check_nfs(t_fname,client_host);
		    if(amarg) {
			replyf(req,"OBJECT-INFO ACCESS-METHOD NFS %s\n",
			       amarg);
			item_count++;
		    }
#endif NFS_EXPORT
		    
#ifdef AFSDIRECTORY
		    if(*afsdir && (sindex(clink->hsoname,afsdir) == 
				    clink->hsoname)) {
			suffix = clink->hsoname + strlen(afsdir);
			replyf(req,"OBJECT-INFO ACCESS-METHOD AFS %s\n",
			       suffix);
			item_count++;
		    }
#endif AFSDIRECTORY

#ifdef AFTPDIRECTORY
		    if(*aftpdir && (sindex(clink->hsoname,aftpdir) == 
				    clink->hsoname)) {
			suffix = clink->hsoname + strlen(aftpdir);
			replyf(req,"OBJECT-INFO ACCESS-METHOD ANONYMOUS-FTP %s %s\n", 
			       suffix,"BINARY");
			item_count++;
			
		    }
#endif AFTPDIRECTORY

		}
		else if(strcmp(t_name,"ACCESS-METHOD") == 0) {
		    
#ifdef NFS_EXPORT
		    amarg = v1_check_nfs(t_fname,client_host);
		    if(amarg) {
			replyf(req,"OBJECT-INFO ACCESS-METHOD ASCII NFS %s\n",
			       amarg);
			item_count++;
		    }
#endif NFS_EXPORT
		    
#ifdef AFSDIRECTORY
		    if(*afsdir && (sindex(clink->hsoname,afsdir) == 
				   clink->hsoname)) {
			suffix = clink->hsoname + strlen(afsdir);
			replyf(req,"OBJECT-INFO ACCESS-METHOD ASCII AFS %s\n",
			       suffix);
			item_count++;
		    }
#endif AFSDIRECTORY

#ifdef AFTPDIRECTORY
		    /* Find the real name of the file and use it */
		    /* To check for AFTP access                  */
/*		    rnl = readlink(clink->hsoname,rname,MAXPATHLEN); */
/* 		    if(rnl >= 0) *(rname+rnl) = '\0';                 */

		    if(*aftpdir && (sindex(clink->hsoname,aftpdir) == 
				    clink->hsoname)) {
			suffix = clink->hsoname + strlen(aftpdir);
			replyf(req,"OBJECT-INFO ACCESS-METHOD ASCII ANONYMOUS-FTP %s %s\n", 
			       suffix,"BINARY");
			item_count++;
		    }
#endif AFTPDIRECTORY
		}
		else {
		    /* Here we must check the file info, look for matching */
		    /* attributes and return them                          */
		    if(rsinfo_ret <= 0) {
			ca = fi->attributes;
			while(ca) {
                            TOKEN tk;
			    if(ca->avtype == ATR_SEQUENCE &&
                               ca->value.sequence &&
                               ((strcmp(t_name,ca->aname) == 0) || 
			       (strcmp(t_name,"ALL") == 0))) {
				replyf(req,"OBJECT-INFO %s ASCII", ca->aname);
                                for (tk = ca->value.sequence; tk; 
                                     tk = tk->next)
                                    replyf(req, " %s", tk->token);
                                reply(req, "\n");
				item_count++;
			    }
			    ca = ca->next;
			}
		    }
		}
		
		/* If none, match, say so */
		if(!item_count)
		    replyf(req,"NONE-FOUND\n");
		
		pffree(fi); fi = NULL;
		vlfree(clink);
		break;
		
	    case RESTART: 
		plog(L_STATUS,req,
		     "Server restarted (restart message received)");
		creplyf(req,"RESTARTING\n");
		restart_server(0,NULL);
		break;

#ifdef DIE
	    case TERMINATE: 
		plog(L_STATUS,req,
		     "Server killed (terminate message received)");
		creplyf(req,"TERMINATING\n");
		log_server_stats();
		exit(0);
#endif DIE
		
	    default: 
		plog(L_DIR_PERR,req,
		     "Unknown message: %s",command);
		creplyf(req,"FAILURE UNIMPLEMENTED %s\n",command);
                return PFAILURE;
	    }
	    
	    get_token(command,'\n');       /* Defined in pprot.h */
	    continue;
	    
	dforwarded:
	    fl = dir->f_info->forward; dir->f_info->forward = NULL;
	    fp = check_fwd(fl,client_dir,dir_magic_no);
            vdir_freelinks(dir);
	    
	forwarded:
	    
	    if(fp) {
		replyf(req,"FORWARDED %s %s %s %s %d %d\n",
		       fp->hosttype,fp->host,fp->hsonametype,fp->hsoname,
		       fp->version,fp->f_magic_no);
	    }
	    else replyf(req,"FORWARDED\n");
	    vllfree(fl);
	    
	    get_token(command,'\n');       /* Defined in pprot.h */
	}
	creply(req,NULL);
	return(PSUCCESS);
    }

/*
 * v1_cmd_lookup - lookup the command name and return integer
 *
 *    V1_CMD_LOOKUP takes a pointer to a string containing a command.
 *    It then looks up the first word found in the string and
 *    returns an int that can be used in a switch to dispatch
 *    to the correct routines.
 *
 *    This has been optimzed for the swerver side of the VFS protocol.
 */
static v1_cmd_lookup(cmd)
char	*cmd;
{
    switch(*cmd) {
    case 'A':
        if(!strncmp(cmd,"AUTHENTICATOR",13))
            return(AUTHENTICATOR);
        else return(UNIMPLEMENTED);
#ifndef PSRV_READ_ONLY
    case 'C':
        if(!strncmp(cmd,"CREATE-OBJECT",11))
            return(CREATE_OBJECT);
        else if(!strncmp(cmd,"CREATE-LINK",11))
            return(CREATE_LINK);
        else if(!strncmp(cmd,"CREATE-DIRECTORY",16))
            return(CREATE_DIRECTORY);
        else return(UNIMPLEMENTED);
#endif
    case 'D':
        if(!strncmp(cmd,"DELETE-LINK",11))
#ifndef PSRV_READ_ONLY
            return(DELETE_LINK);
#else
            return(UNIMPLEMENTED);
#endif
        else if(!strncmp(cmd,"DIRECTORY",9))
            return(DIRECTORY);
        else return(UNIMPLEMENTED);
#ifndef PSRV_READ_ONLY
    case 'E':
        if(!strncmp(cmd,"EDIT-OBJECT-INFO",14))
            return(EDIT_OBJECT_INFO);
        else return(UNIMPLEMENTED);
#endif
    case 'G':
        if(!strncmp(cmd,"GET-OBJECT-INFO",13))
            return(GET_OBJECT_INFO);
        else return(UNIMPLEMENTED);
    case 'L':
        if(!strncmp(cmd,"LIST-ACL",8))
            return(LIST_ACL);
        else if(!strncmp(cmd,"LIST",4))
            return(LIST);
        else return(UNIMPLEMENTED);
#ifndef PSRV_READ_ONLY
    case 'M':
        if(!strncmp(cmd,"MODIFY-ACL",10))
            return(MODIFY_ACL);
        else if(!strncmp(cmd,"MODIFY-LINK",11))
            return(MODIFY_LINK);
        else return(UNIMPLEMENTED);
#endif
    case 'P':
        if(!strncmp(cmd,"PACKET",1))
            return(PACKET);
        else return(UNIMPLEMENTED);
    case 'R':
        if(!strncmp(cmd,"RESTART",7))
            return(RESTART);
        else return(UNIMPLEMENTED);
    case 'S':
        if(!strncmp(cmd,"STATUS",6))
            return(STATUS);
        else return(UNIMPLEMENTED);
    case 'T':
        if(!strncmp(cmd,"TERMINATE",9))
            return(TERMINATE);
        else return(UNIMPLEMENTED);
#ifndef PSRV_READ_ONLY
    case 'U':
        if(!strncmp(cmd,"UPDATE",6))
            return(UPDATE);
        else return(UNIMPLEMENTED);
#endif
    case 'V':
        if(!strncmp(cmd,"VERSION",7))
            return(VERSION);
        else return(UNIMPLEMENTED);
    default:
        return(UNIMPLEMENTED);
    }
}

/* This is quote.c, which is vestigial except for dirsrv_v1(). */
/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#if 0				/* commented out since already 
				 included above. */
#include <stdio.h>
#include <strings.h>
#endif

/*
 * quote - quote string if necessary
 *
 *	      QUOTE takes a string and quotes it if it contains special
 *            characters.  The null string is also quoted.
 *
 *    ARGS:   s - string to be quoted
 *            
 * RETURNS:   The quoted string.  If quoting is required, the string
 *	      appears in static storage, and must be copied if 
 *            it is to last beyond the next call to quote.
 *            If s is null, or the null string, '' is returned.
 *
 *    BUGS:   Still needs to check for additional illegal embedded characters
 */

static
char *
quote(s)
    char	*s;		/* String to be quoted */
    {
	/* Should malloc so no dependancy on size */
	static char	quoted[200];
	char		*qp = quoted;
	char		*sp = s;
	int		needsquoting = 0;

	*qp++ = '\'';

	if(!sp) sp = "";

	while(*sp) {
	    if ((*sp < '#') || (*sp > '~')) needsquoting++;
	    if (*sp == '\'') *(qp++) = '\'';
	    *(qp++) = *sp++;
	}

	*(qp++) = '\'';
	*(qp++) = '\0';

	if((qp == quoted + 3) || needsquoting) return(quoted);
	return(s);
    }



/* v1_check_nfs: vestigial except for dirsrv_v1. --swa@isi.edu, 12/14/92 */
/*
 * v1_check_nfs - Check whether file is available by NFS
 *
 * 	  V1_CHECK_NFS takes the name of a file and a network address.
 *        It returns the name of the filesystem (prefix of the file)
 *        which may be exported by NFS to the client.  The prefix is
 *        followed by a space and the suffix.  This is the form of the 
 *        paramters to be returned for access by NFS.
 *
 *    ARGS: path    - Name of file to be retrieved
 *          client  - IP address of the client
 *
 * RETURNS: Pointer to a string containing the name of the file system or
 *          NULL if the file is not available by NFS
 *
 *   NOTES: The returned string is static.  It must be copied if it
 *          is needed beyond the next call to check_nfs.
 *
 *    BUGS: The procedure should check the exports file.  Right now
 *          It only guesses at the prefix and check to make sure the
 *          request is from the local subnet. 
 */
static
char *
v1_check_nfs(path,client)
    char 	*path;
    long	client;
    {
	static	char	args[MAXPATHLEN];
	static long	myaddr = 0;
	char		prefix[MAXPATHLEN];
	char		*suffix;
	char		*slash;

	/* First time called, find out hostname and remember it */
	if(!myaddr) myaddr = myaddress();

#if BYTE_ORDER == BIG_ENDIAN
	if((myaddr ^ client) & 0xffffff00) return(NULL);
#else
	if((myaddr ^ client) & 0x00ffffff) return(NULL);
#endif

	strcpy(prefix,path);
	slash = index(prefix+1,'/');
	if(slash) {*slash = '\0'; suffix = slash + 1;}
	else return(NULL);

	sprintf(args,"%s %s",prefix,suffix);
	return(args);
}




/* Convert an external link from Version 5 link format to Version 1 format. */
static int
v1_externalize(VLINK vl)
{
    PATTRIB at;
    TOKEN am;                   /* access method itself. */
    if (vl->target && strequal(vl->target, "EXTERNAL")) {
        /* Look for an AFTP access method. */
        for (at = vl->lattrib; at; at = at->next) {
            if (strequal(at->aname, "ACCESS-METHOD")
                && length((am = at->value.sequence)) == 6
                && strequal(am->token, "AFTP")) {
                /* Make sure hosttype, etc, are all correctly set. */
                if (*elt(am, 1))
                    vl->hosttype = stcopyr(elt(am,1), vl->hosttype);
                if (*elt(am,2))
                    vl->host = stcopyr(elt(am,2), vl->host);
                if (*elt(am,3))
                    vl->hsonametype = stcopyr(elt(am,3), vl->hsonametype);
                if (*elt(am,4))
                    vl->hsoname = stcopyr(elt(am,4), vl->hsoname);
                if(strequal(elt(am,5), "BINARY")) {
                    vl->target = stcopyr("EXTERNAL(AFTP,BINARY)", vl->target);
                    return PSUCCESS;
                } else if (strequal(elt(am,5), "TEXT")) {
                    vl->target = stcopyr("EXTERNAL(AFTP,TEXT)", vl->target);
                    return PSUCCESS;
                } else {
                    /* That's really weird.  Must be BINARY or TEXT. Oh well,
                       we're stuck now; go on. */
                    continue;
                }
            }
        } /* for each attribute */
        return PFAILURE;        /* couldn't find an access-method.  How odd. */
    } else
        return PSUCCESS;
}

/* copied from shadowv1v5cv5.c.  Really should go into a separate v1compat.c
   file.  */
static TOKEN
tokenize(s)
    char *s;
{
    TOKEN retval;
    char buf[MAX_DIR_LINESIZE];

    int tmp = qsscanf(s, "%!!s %r", buf, sizeof buf, &s);
    if (tmp < 0)
        internal_error("Buffer overflow!");
    if (tmp == 0)
        return NULL;
    if ((retval = tkalloc(buf)) == NULL)
        internal_error("tkalloc() out of memory!");
    if (tmp == 2)
        retval->next = tokenize(s);
    return retval;
}


#endif /* SERVER_SUPPORT_V1 */
