/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>
 */
#include <usc-copyr.h>
#include <ardp.h>
#include <pfs.h>
#include <pparse.h>
#include <ctype.h>

/* The longest possible word we could read in is ARDP_PTXT_LEN_R.
   We don't cache the value returned from in_nextline(); safe to use static
   data.  Keywords (1st word in a line) are never quoted; this is safe then. */
char *
in_nextline(INPUT oldin)
{
    INPUT_ST in_st;
    INPUT in = &in_st;
    static char buf[ARDP_PTXT_LEN_R + 1];
    char *bufp = buf;
    int c;
    
    input_copy(oldin, in);
    if((c = in_readc(in)) == '\0') /* test for EOF */
        return NULL;
    while (c && isascii(c) && !isspace(c)) {
        *bufp++ = c;
        in_incc(in);
        c = in_readc(in);
        assert(bufp - buf < sizeof buf);
    }
    *bufp = '\0';
    return buf;
}
