/*
 * Copyright (c) 1992 by the University of Southern California
 *
 * For copying and distribution information, please see the file <usc-copyr.h>
 */

#include <usc-copyr.h>

#include <ardp.h>
#include <pfs.h>
#include <pparse.h>
#include <perrno.h>
#include <stdio.h>


resptoin(RREQ resp, INPUT in, char **next_linep)
{
    extern int pfs_debug;

    in->resp = resp;
    in->req = NULL;
    in->f = NULL;
    in->fname = NULL;
    if (resp == NULL) *next_linep = NULL;
    *next_linep = resp->inpkt->ioptr;
}

/* This function assumes that there will be at least 1 line in each packet.
   It also assumes that lines are never split across packets. */
int
get_resp_line(RREQ resp, char **commandp, char **next_wordp, char
   **next_linep)
{
    extern int pfs_debug;
    /* Start of stuff directly copied from get_req_line(). */
    int tmp;                    /* temp return value. */
    char *eol;      /* temp. variable for end of line. */

    if (!next_linep || !*next_linep) {
        internal_error("get_resp_line() called with next_linep or *next_linep \
unset!");
    }
    tmp = qsscanf(*next_linep, "%~%r%*s%~%r%*'(^\n\r)%r%R", commandp,
                  next_wordp, &eol, next_linep); 
    if (tmp < 4) {
        if(pfs_debug) {
            qfprintf(stderr, "Received Prospero packet with an \
unterminated quote, or an empty line, or a line that was not LF terminated.  \
Here is the offending line: %s\n",
                    *commandp, 0);
        }
        return PARSE_ERROR;
    }

    assert(tmp == 4);
    if (**next_linep == '\0') /* last line of packet. */
        *next_linep = NULL;
    /* eol points to the LF terminating the current line. */
    /* Wipe out any trailing spaces.  This makes the rest of the code a little
       bit simpler. */ 
    do 
        --eol;
    while (*eol == ' ' || *eol == '\t');
    *++eol = '\0';
    /* End of stuff directly copied from get_req_line() */
    if (*next_linep == NULL) {
	resp->inpkt = resp->inpkt->next;
        if (resp->inpkt) {
            *next_linep = resp->inpkt->text; /* otherwise, leave set to NULL */
        }
    }
    return PSUCCESS;
}


cl_in_line(INPUT in, char **commandp, char **next_wordp, char **next_linep)
{
    assert(in->resp && !in->req);
    return get_resp_line(in->resp, commandp, next_wordp, next_linep);
}
