/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/times.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */
#include <CMMDlib.h>


#ifdef HPUX
#   define srandom srand
#   define random rand
#endif

#ifndef NUM_ITER 
#  define NUM_ITER 500
#endif

#ifndef ASIZE
#  define ASIZE 1
#endif

#ifndef RNEIGH
#   define RNEIGH(x,tot)    (x<tot)?x+1:1 /* right neighbor of x in the ring */
#endif

#define MAXTIME 12                        /* Maximum computation time in sec.*/
#define INT_SZ sizeof(int)
#define SENDTO_PORT 1                     /* Port_id on destination task */
#define RCVON_PORT  1                     /* Port on which to rcv messages */


float a[ASIZE];

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid, num_iter;
  int time_dcrmt, timeleft, iter_cnt;
  int sendto_task, i, nbytes, rbytes, dum;
  double time, val, red_val;
  char fname[32];
  struct rusage rusage1, rusage2;
  FILE *fd;
  struct timeval tp1, tp2;
  struct timezone tzp;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */

  nbytes = sizeof(float) * ASIZE;
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  num_iter = 100;
  ntasks = numtasks();   /* Total number of tasks in this job */
  
  red_val = (double)1.0;
  
  val = CMMD_reduce_double(red_val, CMMD_combiner_add);

  gettimeofday(&tp1, &tzp);  

  for (i=1; i<= num_iter; i++) {
    
    val = CMMD_reduce_double(1.0, CMMD_combiner_add);
    
  } /* for */

  gettimeofday(&tp2, &tzp);
  
  time = ((double)(tp2.tv_sec - tp1.tv_sec)) +
    ((double)(tp2.tv_usec - tp1.tv_usec)) / 1.0E+6;

  if (my_tid == ntasks) {
    sprintf(fname, "reduce_timings", nbytes, ntasks);
    fd = fopen(fname, "a");
    fprintf(fd, "%d\t %d\t %f \n", num_iter, ntasks, time);
    fclose(fd);
  }
  io_printf(" done.\n", my_tid, (char *)0 );
  
  exit(0);
}

