/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 * 
 * Written by srao 9/92
 */

#include <prm-copyr.h>


#include <unistd.h>
#include <fcntl.h>

extern u_long my_tid;
extern char *p_err_string;

qsort(a, m, n)
float a[];
int m, n;
{
  int i, j;
  float pivot, tmp;

  if (m >= n) return;
  i = m;
  j = n+1;
  pivot = a[m];
      
  for(;;) {
    do 
      i++;
    while(a[i] < pivot);
         
    do 
      j--;
     while(a[j] > pivot);

    if (i < j) {
      tmp = a[j];
      a[j] = a[i];
      a[i] = tmp;
    }
    else
      break;
  }
  tmp = a[j];
  a[j] = a[m];
  a[m] = tmp;

  qsort(a, m, j-1);
  qsort(a, j+1, n);
       
}


merge(a, start, middle,  len)
float a[];
int start, middle, len;
{
  int i, j, m, n, ind;
  float *b;

  i=start;
  j=middle;
  m= middle-1;
  n = start+len-1;
  b = (float *)calloc(len, sizeof(float));

  ind =0;
  while( (i<=m) && (j<=n) ) {

    if (a[i] <= a[j]) 
      *(b+ind) = a[i++];
    else 
      *(b+ind) = a[j++];

    ++ind;
  }
  if (i>m) {
    bcopy(b, &a[start], (j-start)*sizeof(float));
  }
  else {
    bcopy(&a[i], (b+ind), (m+1-i)*sizeof(float) );
    bcopy(b, &a[start], len*sizeof(float));
  }    
}


char *
write_output_file(dfname, a, first, length, iter_num)

char dfname[];
float a[];
int first, length, iter_num;
{

  char *outflname, extn[16], *dot;
  int ofd, nbytes;

  outflname = (char *)malloc(80);
  strcpy(outflname, dfname);
  sprintf(extn,"inr%d", my_tid);
  dot = (char *)index(outflname,'.');
  if (dot) 
    *(dot+1) = '\0';
  else
    strcat(outflname, ".");
  strcat(outflname, extn);
  
  ofd = io_open(outflname, O_WRONLY|O_CREAT, 0x1B4);
  nbytes = length*sizeof(float);
  if (io_write(ofd, a + first, nbytes, 0) != nbytes) {
    io_printf("write failed! iter=%d: %s", my_tid, iter_num, &p_err_string, 
	      (char *)0);
    exit(1);
  }
  io_close(ofd);
  return outflname;
}
