/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifdef HPUX
#   define srandom srand
#   define random rand
#endif

#ifndef RNEIGH
#   define RNEIGH(x,tot)    ((x<tot)?x+1:1) /* right neighbor of x in ring */
#endif

#ifndef LNEIGH
#   define LNEIGH(y,tot)    ((y==1)?tot:y-1)
#endif

#define MAXTIME 12                        /* Maximum computation time in sec.*/
#define INT_SZ sizeof(int)

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid, i;
  int comp_time, intime, timeleft, iter_cnt;
  int sendto_task, rcvfrom_task;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  timeleft = MAXTIME;
  ntasks = numtasks();   /* Total number of tasks in this job */
  
  sendto_task = RNEIGH(my_tid,ntasks);   /* My right neighbor in the ring */
  rcvfrom_task = LNEIGH(my_tid,ntasks);

  srandom(getjid() + 10 * my_tid);

  for (iter_cnt = 1; iter_cnt <= 5; iter_cnt++) {
    /* Number of seconds for which computation is  performed */
    comp_time = random()%5 + 5;   
    
    sleep(comp_time);         /* Simulate computation by sleeping */
    
    io_printf("completed iteraton %d. ...sending to task %d and rcving from task %d", iter_cnt, sendto_task, rcvfrom_task, (char *)0);
    
    /* Send and receive messages */ 
    for (i = 1; i < ntasks; i++) {
      vsendrecv (rcvfrom_task, ANY_TAG, &intime, INT_SZ,
		sendto_task,  ANY_TAG, &comp_time, INT_SZ);
    
      comp_time = intime;
      sleep(comp_time);
    } 
  }

  io_printf("done.\n", (char *)0 );
  
  exit(0);
}

