/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/times.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#define SENDTO_PORT 1                     /* Port_id on destination task */
#define RCVON_PORT  1                     /* Port on which to rcv messages */

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid, npkts;
  int time_dcrmt, timeleft, iter_cnt;
  int sendto_task, nbytes, rbytes;
  int time_secs, time_usecs, rcv_len;
  double time;
  char *a;
  char fname[32];
  struct rusage rusage1, rusage2;
  FILE *ifd, *ofd;
  register int i;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  if( (ifd = fopen("longsend.in", "r")) == NULL) {
    perror("fopen longsend.in");
    exit(1);
  }
  fscanf(ifd, "%d %d", &npkts, &iter_cnt);
  nbytes = npkts * PRM_APP_MSG_LEN;
  a = (char *)malloc(nbytes);
  
  if (my_tid == 1) { 
    vsend(2, SENDTO_PORT, ANY_TAG, a, 4); 
    
    getrusage(RUSAGE_SELF, &rusage1);
    for (i = 1; i<= iter_cnt; i++)  {
      io_printf("iter %d: sending long message (%d bytes) to task 2", 
		i, nbytes);
      vsend(2, SENDTO_PORT, ANY_TAG, a, nbytes); 
    }
    getrusage(RUSAGE_SELF, &rusage2);
    

    time = (double) ((rusage2.ru_utime.tv_sec - rusage1.ru_utime.tv_sec) +
		      (rusage2.ru_stime.tv_sec - rusage1.ru_stime.tv_sec) ) +
			((double)((rusage2.ru_utime.tv_usec - 
				   rusage1.ru_utime.tv_usec) +
				  (rusage2.ru_stime.tv_usec -
				   rusage1.ru_stime.tv_usec)) 
			 ) / 1.0E+6;
    sprintf(fname, "long_timings_%d", nbytes);
    ofd = fopen(fname, "a");
    fprintf(ofd, "%d\t %f \n", iter_cnt, time);
    fclose(ofd);
  }
  
  else {
    vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, a, 4);

    for (i=1; i<= iter_cnt; i++) {
      rcv_len = vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, a, nbytes);
      io_printf("iter %d: Rcvd long message (%d bytes)", 
		i, rcv_len, (char *)0);
    }      
  }
  
  io_printf("done", (char *)0);
  exit(0);
}

