/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1993             by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>.
 */

#include <uw-copyright.h>
#include <usc-copyr.h>
#include <stdio.h>
#include <strings.h>
#include <pfs.h>                /* for defs. of functions in this file. */

int	string_count = 0;
int	string_max = 0;

/*
 * stcopy - allocate space for and copy a string
 *
 *     STCOPY takes a string as an argument, allocates space for
 *     a copy of the string, copies the string to the allocated space,
 *     and returns a pointer to the copy.
 */

char *
stcopy(const char *st)
{
    return(stcopyr(st,0));
}

/*
 * stcopyr - copy a string allocating space if necessary
 *
 *     STCOPYR takes a string, S, as an argument, and a pointer to a second
 *     string, R, which is to be replaced by S.  If R is long enough to
 *     hold S, S is copied.  Otherwise, new space is allocated, and R is
 *     freed.  S is then copied to the newly allocated space.  If S is
 *     NULL, then R is freed and NULL is returned.
 *
 *     In any event, STCOPYR returns a pointer to the new copy of S,
 *     or a NULL pointer.
 */
char *
stcopyr(const char *s, char *r)
{
    int	sl;
    int	rl;

    if(!s && r) {
        free(r - sizeof (int));
        string_count--;
        return(NULL);
    }
    else if (!s) return(NULL);

    sl = strlen(s) + 1;

    if(r) {
        rl = stsize(r);
        if(rl < sl) {
            free(r - sizeof (int));
            r = (char *) malloc(sl + sizeof (int));
            /* Check for out of memory.  not too cool, but better than segfaulting. */
	    if (!r) out_of_memory();
            * (int *) r = sl;
            r += sizeof (int);
        }
    }
    else {
        r = (char *) malloc(sl + sizeof (int));
	if (!r) out_of_memory();
        * (int *) r = sl;
        r += sizeof (int);
        string_count++;
        if(string_max < string_count) string_max = string_count;
    }
    strcpy(r,s);
    return(r);
}

#if 0                           /* Dead code??  see if it's ever useful again.
                                   */ 
/* Return a string with enough room to hold SIZE bytes, including the trailing
   null.  Copy the old string stored in OLDSTR onto it, too. */
char *
stresize(const char *oldstr, int newsize)
{
    char *newstr;
    if (stsize(oldstr) < newsize) {
        assert(newstr = (char *) malloc(newsize + sizeof (int)));
        * (int *) newstr = newsize;
        newstr += sizeof (int);
        strcpy(newstr, oldstr); /* we know newstr has enough space. */
        free(oldstr - sizeof (int));
        return newstr;
    } else {
        return oldstr;
    }
}
#endif

/*
 * stalloc - Allocate space for a string
 *
 *     STALLOC allocates space for a string by calling malloc.
 *     STALLOC guarantees never to honor requests for zero or fewer bytes of
 *      memory. 
 */
char *
stalloc(int size)
{
    void	*st;

    if (size <= 0) return NULL;
    st = (void *) malloc(size + sizeof (int));
    if(st) {
        * (int *) st = size;
        st += sizeof (int);
        string_count++;
        if(string_max < string_count) string_max = string_count;
    } else {
	out_of_memory();
    }
    return(st);
}

/*
 * stfree - free space allocated by stcopy or stalloc
 *
 *     STFREE takes a string that was returned by stcopy or stalloc 
 *     and frees the space that was allocated for the string.
 */
stfree(void *st)
{
    if(st) {
        free(st - sizeof (int));
        string_count--;
    }
}


