/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 7/92
 *
 */

#include <prm-copyr.h>

#include <ardp.h>

#include <sys/socket.h>
#include <stdio.h>
#include <sys/types.h>

#define  MAIN_PROG
#include <comm.h>

#ifdef HPUX
#   include <signal.h>
#endif

char *progname;


main(int argc, char *argv[], char *envp[])
{
  int     c;
  int     ntasks;
  char    buf[MAX_DIR_LINESIZE];
  char    *progname, *msg;
  u_char  op, my_op, out_stream;
  u_char  clnt_portnum;
  u_short my_udp_port_num;
  u_long  len, msg_tag;
  u_long  clnt_taskid;
  RREQ    current_req;
  PTEXT   pkt, rpkt;

  extern  void (*sigint_handler)();

  signal(SIGINT, sigint_handler);

  _progname = progname = argv[0];
  sscanf(argv[1], "%lu", &_my_jobid);
  sscanf(argv[2], "%hu", &my_udp_port_num);

  sprintf(buf,"#%d", my_udp_port_num);
  ardp_bind_port(buf);

  /* Jobmngr enforced synchronization of all tasks */

  do {
    current_req = ardp_get_nxt();
  } while( *(current_req->rcvd->start + PRM_OPCODE_OFF) != PRM_SYNC_TASKS);

  current_req->outpkt = ardp_ptalloc();
  *(current_req->outpkt->start + PRM_OPCODE_OFF) = (u_char)PRM_SYNC_RESP;
  *(current_req->outpkt->start + PRM_STATUS_OFF) = (u_char)SUCCESS;
  current_req->outpkt->length = PRM_STATUS_OFF + 1;
  ardp_respond(current_req, ARDP_R_COMPLETE);

  ntasks = numtasks();
  trsln_cache = (struct cache *)calloc((ntasks + 1), sizeof(struct cache));
  bzero(trsln_cache, (ntasks + 1) * sizeof(struct cache));

  /* Here is where the initialization procedure is called. */

  if (TIO_init_procedure() == -1) {
    fprintf(stderr, "Error occured in program initialization\n");
    _jm_host_addr = get_dest_addr(0, 0);
    current_req = ardp_rqalloc();
    current_req->outpkt = ardp_ptalloc();
    *(current_req->outpkt->start + PRM_OPCODE_OFF) = PRM_APPL_ERR;
    ardp_send(current_req, 0, _jm_host_addr, -1);  /* Send to jobmngr */
  }

  for (;;) {
    
    current_req = ardp_get_nxt();
    
    pkt = current_req->rcvd;
    msg = pkt->start;
    op  = *(msg + PRM_OPCODE_OFF);
    
    switch(op) {
      
    case PRM_IO_PRINT:
      
      out_stream = *(msg + PRM_ADINF_OFF);      /* stdout or stderr */

      bcopy ( msg + PRM_TINFO_OFF, &clnt_taskid, LONG_SZ);
      clnt_taskid = ntohl(clnt_taskid);
      
      extract_from_pkts(pkt, buf, MAX_DIR_LINESIZE); 
      
	if (clnt_taskid)
	  fprintf((&_iob[out_stream]), "(task %2d) %s\n", clnt_taskid, buf);
	else 
	  fprintf((&_iob[out_stream]), "%s\n", buf);

      if (ardp_replyf(current_req, ARDP_R_COMPLETE, "%c%c%c", 
		      (u_char)PRM_PROTO_V, (u_char)PRM_PRINT_RESP, 
		      (u_char)SUCCESS, (char *)0 ) 
	  != ARDP_SUCCESS)
	fprintf(stderr, "(%s) transmit failed.\n", progname);
      
      break;


    case PRM_APP_MSG:
      
      bcopy (msg + PRM_TINFO_OFF, &clnt_taskid, LONG_SZ);
      clnt_taskid = ntohl(clnt_taskid);
      
      bcopy (msg + PRM_DATA_OFF, &msg_tag, LONG_SZ);
      msg_tag = ntohl(msg_tag);

      bcopy(msg + PRM_DLEN_OFF, &len, LONG_SZ);
      len = ntohl(len);
      bcopy(msg + PRM_APPDT_OFF, buf, len);

      current_req->outpkt = ardp_ptalloc();
      prm_headers(current_req->outpkt, (u_char)PRM_AMSG_RESP, (u_char)SUCCESS,
		  (u_char)0, 0);
      current_req->outpkt->length = PRM_STATUS_OFF + 1;
      ardp_respond(current_req, ARDP_R_COMPLETE); 
      perform_global_op(clnt_taskid, msg_tag, buf, len);

      break;


    case PRM_SYNC_TASKS:

      current_req->outpkt = ardp_ptalloc();
      *(current_req->outpkt->start + PRM_OPCODE_OFF) = (u_char)PRM_SYNC_RESP;
      *(current_req->outpkt->start + PRM_STATUS_OFF) = (u_char)SUCCESS;
      current_req->outpkt->length = PRM_STATUS_OFF + 1;
      ardp_respond(current_req, ARDP_R_COMPLETE);

      break;


    case PRM_JOB_DONE:

      if ( ardp_replyf(current_req, ARDP_R_COMPLETE, "%c%c%c", 
		       (u_char)PRM_PROTO_V, (u_char)PRM_JDONE_RESP, 
		       (u_char)SUCCESS)  != ARDP_SUCCESS)
	fprintf(stderr, "(%s) transmit failed.\n", progname);
      
      exit(0);
      break;
      
    default:
      fprintf(stderr, "(%s) cannot perform requested operation (code=%d)!\n", 
	      progname, op);
      
      break;
    }
  }
}


void
sigint_handler(sig, code, scp, addr)
int sig, code;
struct sigcontext *scp;
char *addr;
{
  signal(SIGINT, SIG_IGN);
  kill(getppid(), SIGINT);
  signal(SIGINT, sigint_handler);
}

