/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>
#include <nodemngr.h>

extern prm_job_t job_table;

prm_job_t
  prm_jalloc(jid_t jid, prm_node_addr_t jm_addr)
{
  prm_job_t curjob;

  curjob = (prm_job_t) malloc(sizeof(struct prm_job));
  curjob->jid = jid;
  curjob->numtasks = 0;
  curjob->auth_key = 0;
  curjob->taskptr = (prm_task_t)0;
  curjob->ctag = NULL;

  bcopy(jm_addr, &(curjob->jmaddr), PRM_AD_SZ);

  /* NOTE: this assumes that jobmngr doesn't migrate, so the host 
     address of IOtasks are the same as that of jobmngr */
  bcopy(jm_addr, &(curjob->iotaddr), PRM_AD_SZ);
  bcopy(jm_addr, &(curjob->fioaddr), PRM_AD_SZ);


  APPEND_ITEM(curjob,job_table);
  
  return curjob;
}

