/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 1/93
 *
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <ardp.h>

#include <sys/socket.h>
#include <signal.h>       /* To handle signals from child tasks, timers */
#include <sys/wait.h>     /* To obtain exit status of child */
#include <utmp.h>
#include <netdb.h>

#include <nodemngr.h>

#include <comm.h>

get_l2p_from_remote(u_char portid, jid_t jid, tid_t tid, 
		    prm_node_addr_t addrp)
{
  
  PTEXT pkt, rpkt;
  RREQ  newreq;
  char *msg;
  u_long ntmp1;
  
  /*  get l->p mapping from the remote nodemngr */

  pkt = ardp_ptalloc();  /* FILL THIS UP */
  prm_headers(pkt, (u_char)PRM_ADDR_XLAT, 0, portid, jid);
  msg =  pkt->start;
  
  ntmp1 = htonl(tid);
  bcopy(&ntmp1, msg + PRM_TINFO_OFF, LONG_SZ);
  pkt->length = PRM_TINFO_OFF + LONG_SZ;
  addrp->sin_port = htons((u_short)NODEMNGR_PORT);
  
  newreq = ardp_rqalloc();
  newreq->outpkt = pkt;
  ardp_send (newreq, 0, addrp, -1);
  rpkt = newreq->rcvd;
  
  if (rpkt == NOPKT) {
    addrp->sin_port = 0;
    fprintf (stderr, "(%s %s) remote nodemngr on %s did not respond!\n", 
	     _progname, _my_hostname, inet_ntoa(addrp->sin_addr) );
  } 
  else {
    msg = rpkt->start;
    if (*(msg + PRM_STATUS_OFF) == SUCCESS) { /* got port  & addr */
      bcopy(msg + PRM_DATA_OFF, addrp, PRM_AD_SZ);
      addrp->sin_family = AF_INET;
    }
    else
      addrp->sin_port = 0;
  } 
  ardp_rqfree(newreq);
  if (addrp->sin_port)
    return SUCCESS;
  else
    return ERRORCODE;
} 
