/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 3/93
 *
 */

#include <prm-copyr.h>


#include <stdio.h>

#ifndef MACH386
#include <stdlib.h>
#endif

#ifdef HPUX
#   include <signal.h>
#endif

#if defined(SUNOS)
#   include <vfork.h>
#endif

#include <sys/time.h>
#include <sgtty.h>   
#include <fcntl.h>

#define PRM_PROG
#include <comm.h>

#include <jobmngr.h>

extern TDES *ttbl;
extern u_long ntasks_running;
extern prm_node_addr  my_node_addr;
extern int num_sm_hosts, ntasks;
extern char *sm_hostname, *sm_hostlist[], buffer[];


/*
  process_init_req: Takes an incomplete task-creation request, req, and taskid
  of the task and waits until the request completes. Returns result of the
  creation request, which is 0 if task was successfully created, non-zero
  otherwise. 
*/

process_init_req(RREQ req, int taskid)
{
  int st;
  u_short val;
  char *msg;

  st = process_pending_req(req);
  if ((st == J_NO_NM) || (st == J_ARDP_ERR))
    return st;

  msg = req->rcvd->start;
  bcopy(msg + PRM_DLEN_OFF, &val, 2);
  if (st == J_AUTH_FAIL) {
    val = ntohs(val);
    if (val)
      bcopy(msg + PRM_DATA_OFF, p_err_string, val);
    
    return J_TASK_INIT;
  }
  ttbl[taskid]->port = val;    /* In network_byte order */ 
  ++ntasks_running;
  ttbl[taskid]->status = T_RUNNING;
  return SUCCESS;
}


/* process_pending_req: Processes incomplete requests until they complete */

process_pending_req(RREQ req)
{
  u_char status;
  PTEXT rpkt;
  RREQ cmpreq;
  extern RREQ ardp_completeQ;

  if (req->status != ARDP_STATUS_COMPLETE) {
    if(ardp_retrieve(req, -1) != ARDP_SUCCESS)
      return J_ARDP_ERR;
  }
  else {
    cmpreq = ardp_completeQ;
    while(cmpreq && ( cmpreq != req)) 
      cmpreq = cmpreq->next;
    if (cmpreq)
      EXTRACT_ITEM(req, ardp_completeQ);
  }
  if( (rpkt = req->rcvd) == NOPKT) {  /* No ack recvd */
    fprintf(stderr, "(%s) nodemngr at %s not responding!!!\n",
	    _progname, inet_ntoa(req->peer_addr) );
    return J_NO_NM;
  }
  else {  /* Check if authorization was successful  */
    status = *(rpkt->start + PRM_STATUS_OFF);
    if (status == FAILURE)  {
      return J_AUTH_FAIL;
    }
    else
      return 0;
  }
}



/* PRM_request resources: Request resources from sysmngr */


PTEXT
  PRM_request_resources()
{
  PTEXT pkt, rpkt;
  RREQ newreq;
  char *msg;
  u_long ntmp;

  pkt = ardp_ptalloc();
  prm_headers(pkt, (u_char)PRM_RSC_REQ, 0, 0, _my_jobid);
  msg = pkt->start;

  ntmp = htonl(ntasks);
  bcopy(&ntmp, msg + PRM_TINFO_OFF, LONG_SZ);
  pkt->length = PRM_TINFO_OFF + LONG_SZ;
  
#if MULTI_HOST
  pkt->length = PRM_DATA_OFF;
  for (i = 0; i < MAX_HOST_TYPES; i++ ) {
    ntmp = htonl(h_type_reqd[i]);
    bcopy(&ntmp, msg + pkt->length, LONG_SZ);
    pkt->length += LONG_SZ;
  }
#endif
  
  newreq = ardp_rqalloc();
  newreq->outpkt = pkt;
  if ((perrno = ardp_send (newreq, buffer, 0, -1)) != ARDP_SUCCESS)
    rpkt = NOPKT;
  else {
    rpkt = newreq->rcvd;
    newreq->rcvd = NOPKT;
    ardp_rqfree(newreq);
  }
  return rpkt;
}



/* JM_send_pkts_to_nm: Sends a sequence of pkts (specified by pkt_list) to 
   the nodemngr specified by addr. Data in map_pkts are copied into separate
   pkts so that map_pkt remains intact on return. This function is useful
   when the same data has to be sent to multiple nodemngrs. Ex: the task map.
   If ttwait is -1, the send waits for the response and returns a reply code.
   If ttwait is 0, the send returns immediately without waiting for the reply.
   
*/


int
  JM_send_pkts_to_nm(addr, pkt_list, ttwait)
prm_node_addr_t addr;
PTEXT pkt_list;
int ttwait;
{
  int retval;
  PTEXT cur_pkt, pkt, rpkt;
  RREQ newreq;
  u_char reply_op;

  retval = SUCCESS;
  
  newreq = ardp_rqalloc();
  cur_pkt = pkt_list;
  while(cur_pkt) {
    pkt = ardp_ptalloc();
    bcopy(cur_pkt->start, pkt->start, cur_pkt->length);
    pkt->length = cur_pkt->length;
    APPEND_ITEM(pkt, newreq->outpkt);
    cur_pkt = cur_pkt->next;
  }

  addr->sin_port = htons((u_short) NODEMNGR_PORT);

  ardp_send (newreq, 0, addr, ttwait);

  if ( (rpkt = newreq->rcvd) == NOPKT) {
    if (ADDR_REMOTE(addr,&my_node_addr))
      fprintf(stderr, "(%s) nodemngr %s is not responding\n", _progname, 
	      inet_ntoa(addr->sin_addr));
    else
      fprintf(stderr, "(%s) Local nodemngr is not responding\n", _progname); 
    retval = J_NO_NM;
  }
  else {  /* Check if authorization was successful  */
    reply_op = *(rpkt->start + PRM_STATUS_OFF);
    if (reply_op == FAILURE) {
      if (ADDR_REMOTE(addr,&my_node_addr))
	fprintf(stderr, "(%s) Authorization on nodemngr %s failed!\n", 
		_progname, inet_ntoa(addr->sin_addr)); 
      else
	fprintf(stderr, "(%s) Authorization on local nodemngr failed!\n", 
		_progname); 
      retval = J_AUTH_FAIL;
    }
  }    
  ardp_rqfree(newreq);
  return retval;
}
