/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 2/93
 *
 */

#include <prm-copyr.h>


#include <ardp.h>

#include <stdio.h>
#include <sys/types.h>

#include <sys/wait.h>     /* To obtain exit status of child */
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <errno.h>

#if defined(SUNOS)
#include <vfork.h>  /* mach386 and HPUX systems don't have this header file */
#endif

#define  MAIN_PROG
#include <comm.h>

#include <pdap.h>

#ifdef HPUX
#   include <signal.h>
#endif

#define MAX_OPENFILES  8  /*  A task can have upto 8 remote files open */

u_long mytaskid, nbytes;
int pfs_debug, perrno, tty_flag;
char *progname;
char    p_err_string[P_ERR_STRING_SZ];
extern char *sys_errlist[];


#define LOC_BIN_FILE_DIR "/tmp"

#define DirName  argv[1] + 1  /* Drop the '0' character at beginning of the
				 string */
#define FileName argv[2]
#define TaskArgs argv[2]

char locdir[80];

struct task_fpset {
  u_long tid;
  int cnt;
  int fd[MAX_OPENFILES];     
  struct task_fpset *next;
};

struct task_fpset *fptr_list, *cur_fpset;

main(int argc, char **argv, char *envp[])
{
  char *dname, pathname[MAXPATHLEN];
  extern char *get_bin_file();
  char    buf[ARDP_PTXT_LEN+1];
  char    fpath[MAXPATHLEN];
  char    *progname, *msg, *rmsg, fname[200];
  u_char  req_fd;
  u_char  clnt_portnum;
  u_short filepathlen, emsglen, my_udp_port_num, flen;
  u_long  len, msg_tag;
  u_long  clnt_taskid, nlen, loc_cpy_mtime;
  int     i, fsize, npkts, pkt_size, whence, offset, cur_pos;
  int     pdap_datalen, n_oct, timetowait;
  RREQ    current_req;
  PTEXT   pkt, rpkt, pkt_i;
  struct  stat statinfo;
  int     bin_fd, read_fd, io_fd, write_fd, open_fd;  
  int     flags, mode;

  _progname = progname = argv[0];
  sscanf(argv[2], "%lu", &_my_jobid); 
  sscanf(argv[3], "%hu", &my_udp_port_num);

  sprintf(buf,"#%d", my_udp_port_num);
  ardp_bind_port(buf);

  for ( ; ; ) {

    current_req = ardp_get_nxt();

    pkt = current_req->rcvd;
    msg = pkt->start;

    rpkt = ardp_ptalloc();
    APPEND_ITEM(rpkt,current_req->outpkt);
    rmsg  = rpkt->start;
    *rmsg = (char)PDAP_VERSION; ++rmsg;
    
    if (*msg != PDAP_VERSION) {
      *rmsg = (char)2; *(rmsg + 1) = (char)PDAP_FAILURE; *(rmsg + 2) = 0;
      current_req->outpkt->length = 5;
      ardp_respond(current_req, ARDP_R_COMPLETE);
      break;
    }
    ++msg;
    
    switch(*msg) {

    case PDAP_FILE_XFER:
      
      *rmsg = (u_char)PDAP_FXFER_RESP; ++rmsg;
      ++msg;
      DECODE_ASN1_LENGTH(msg,filepathlen);
      bcopy(msg, fpath, filepathlen);  msg += filepathlen;
      DECODE_ASN1_LENGTH(msg,loc_cpy_mtime);
      
      if (stat(fpath, &statinfo) == -1) {
	sprintf(p_err_string, "%s: %s", fpath, sys_errlist[errno]);
	io_printf("(%s) Could not get stat for %s", progname, p_err_string,
		  (char *)0);
	
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	break;
      }
      if (statinfo.st_mtime < loc_cpy_mtime) {
	*rmsg = (char)2;
	*(rmsg + 1) = SUCCESS; 
	*(rmsg + 2) = COPY_CRNT;
	current_req->outpkt->length = 5;
	ardp_respond(current_req, ARDP_R_COMPLETE);
	break;
      }
      if( (bin_fd = open(fpath, O_RDONLY, 0)) < 0) {
	sprintf(p_err_string, "%s: %s", fpath, sys_errlist[errno]);
	io_printf("(%s) Could not open %s", progname, p_err_string,
		  (char *)0);
	
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	break;
      }
      
      if ((timetowait = len/(2 * PDAP_DATA_PKT_SZ)) > 8)
	ardp_rwait(current_req, timetowait, 0, 0);
      
      /* NOTE: Below, it is assumed that the length of the file > 1K */
      if ((len = PDAP_read_file_into_pkts(current_req, bin_fd, 
					  statinfo.st_size)) ==  -1) {
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	break;
      }
      N_OCTETS(len,n_oct);
      pdap_datalen = len + n_oct + 2;
      ENCODE_ASN1_LENGTH(rmsg,pdap_datalen);
      *rmsg = PDAP_SUCCESS; ++rmsg; *rmsg = COPY_OOD; ++rmsg;
      ENCODE_ASN1_LENGTH(rmsg,len);
      rpkt->length = rmsg - rpkt->start;

      ardp_respond(current_req, ARDP_R_COMPLETE);
      close(bin_fd);
      
      break;
      
      
    case PDAP_READ:
      
      ++msg;
      *rmsg = (char)PDAP_READ_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen);
      if(*msg != PDAP_HNDL_INT) {
	PDAP_fsrv_err(current_req, PDAP_HNDL_TYP, "Unsupported Handle Type");
	break;
      }
      ++msg; req_fd = *msg;  ++msg;
      DECODE_ASN1_LENGTH(msg,offset);
      DECODE_ASN1_LENGTH(msg,nbytes); 
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      cur_fpset = fptr_list;
      while (cur_fpset && (cur_fpset->tid != clnt_taskid))
	cur_fpset = cur_fpset->next;
      
      if(!cur_fpset || (req_fd >= MAX_OPENFILES) || 
	 ( (read_fd = cur_fpset->fd[req_fd]) == 0)) {
	PDAP_fsrv_err(current_req, PDAP_BADF, "Invalid handle value");
	break;
      }
      
      if( fstat(read_fd, &statinfo) == -1) {
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	break;
      }
      if ((cur_pos = lseek(read_fd, offset, SEEK_CUR)) == -1) {
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	break;
      }
      len = MIN(statinfo.st_size - cur_pos, nbytes);
      
      if (len <= 125) {
	*rmsg =len + 2; ++rmsg;
	*rmsg = PDAP_SUCCESS; ++rmsg;
	*rmsg = len; ++rmsg;
	if (read(read_fd, rmsg, len) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
	rpkt->length = len + 5;
      }
      else if (len <= 127) {
	ENCODE_ASN1_LENGTH(rmsg,len+2);
	*rmsg = PDAP_SUCCESS; ++rmsg;
	*rmsg = len; ++rmsg;
	if (read(read_fd, rmsg, len) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
	rpkt->length = len + 6;
      }
      else if (len <= 1024) {
	ENCODE_ASN1_LENGTH(rmsg,len+3);
	*rmsg = PDAP_SUCCESS; ++rmsg;
	ENCODE_ASN1_LENGTH(rmsg,len); 
	if (read(read_fd, rmsg, len) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
	rpkt->length = len + 7;
      }
      else {   /* Need 2 pkts or more for data */
	/* send backoff pkt */
	npkts = len/PDAP_DATA_PKT_SZ;
	if (npkts > 12) {
	  timetowait = npkts/2;
	  ardp_rwait(current_req, timetowait, 0, 0);
	}
	if ((len = PDAP_read_file_into_pkts(current_req, read_fd, nbytes)) == 
	    -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
	N_OCTETS(len,n_oct);
	pdap_datalen = len+n_oct+1;
	ENCODE_ASN1_LENGTH(rmsg,pdap_datalen);
	*rmsg = PDAP_SUCCESS; ++rmsg;
	ENCODE_ASN1_LENGTH(rmsg,len);
	N_OCTETS(pdap_datalen,n_oct);
	rpkt->length = (pdap_datalen-len)+n_oct+2;
      }
      ardp_respond(current_req, ARDP_R_COMPLETE);
      
      break;
      
      
    case PDAP_WRITE:
      
      ++msg;
      *rmsg = (char)PDAP_WRITE_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen); 
      if(*msg != PDAP_HNDL_INT) {
	PDAP_fsrv_err(current_req, PDAP_HNDL_TYP, "Unsupported Handle Type");
	break;
      }
      req_fd = *(++msg);  ++msg;
      DECODE_ASN1_LENGTH(msg,offset);
      DECODE_ASN1_LENGTH(msg,nbytes); 
      
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      cur_fpset = fptr_list;
      while (cur_fpset && (cur_fpset->tid != clnt_taskid))
	cur_fpset = cur_fpset->next;
      
      if(!cur_fpset || (req_fd >= MAX_OPENFILES) || 
	 ( (write_fd = cur_fpset->fd[req_fd] ) == 0)) {
	PDAP_fsrv_err(current_req, PDAP_BADF, "Invalid handle value");
	break;
      }
      
      if (nbytes <= PDAP_DATA_PKT_SZ) {
	if (offset) 
	  if (lseek(write_fd, offset, SEEK_CUR) == -1) {
	    PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	    break;
	  }
	if ((len = write(write_fd, msg, nbytes)) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
      }	  
      else {
	npkts = len/PDAP_DATA_PKT_SZ;
	if (npkts > 12) {
	  timetowait = npkts;
	  ardp_rwait(current_req, timetowait, 0, 0);
	}
	if ((len = PDAP_write_pkts_to_file(current_req->rcvd->next, write_fd,
					   nbytes, offset)) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
      }
      
      N_OCTETS(len,n_oct);
      pdap_datalen = n_oct + 1;
      ENCODE_ASN1_LENGTH(rmsg,pdap_datalen);
      *rmsg = PDAP_SUCCESS; ++rmsg;
      ENCODE_ASN1_LENGTH(rmsg,len);
      rpkt->length = rmsg - rpkt->start;
      
      ardp_respond(current_req, ARDP_R_COMPLETE);
      
      break;
      
      
    case PDAP_OPEN:
      
      ++msg;
      *rmsg = (char)PDAP_OPEN_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen); 
      DECODE_ASN1_LENGTH(msg,flags);
      if (*msg != PDAP_FS) {
	PDAP_fsrv_err(current_req, PDAP_NAME_TYP, 
		      "Unsupported filename type");
	break;
      }       
      ++msg;
      N_OCTETS(flags,n_oct);
      bcopy(msg, fname, nlen - n_oct - 1);
      msg += nlen - n_oct - 1;
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      mode = 0x1b4;
      
      cur_fpset = fptr_list;
      while (cur_fpset && (cur_fpset->tid != clnt_taskid) ) 
	cur_fpset = cur_fpset->next;
      if(!cur_fpset) {
	cur_fpset = (struct task_fpset *)malloc(sizeof(struct task_fpset));
	cur_fpset->tid = clnt_taskid;
	cur_fpset->cnt = 0;
	cur_fpset->next = fptr_list;
	fptr_list = cur_fpset;
      }
      
      if (cur_fpset->cnt < MAX_OPENFILES) {
	i = -1; 
	while (cur_fpset->fd[++i] != 0);
	io_fd = i;
	if ((open_fd = open(fname, flags, mode)) == -1) {
	  PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
	  break;
	}
      }
      else {
	PDAP_fsrv_err(current_req, PDAP_TOO_MANY, "Too many open files");
	break;
      }
      cur_fpset->fd[io_fd] = open_fd;
      
      *rmsg = 4; ++rmsg;
      *rmsg = PDAP_SUCCESS; ++rmsg;
      *rmsg = PDAP_HNDL_INT; ++rmsg;
      *rmsg = 1; ++rmsg;
      *rmsg = io_fd;
      rpkt->length = 7;
      ardp_respond(current_req, ARDP_R_COMPLETE);
      
      break;
      
      
    case PDAP_CLOSE:
      
      ++msg;
      *rmsg = (char)PDAP_CLOSE_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen);
      if(*msg != PDAP_HNDL_INT) {
	PDAP_fsrv_err(current_req, PDAP_HNDL_TYP, "Unsupported Handle Type");
	break;
      }
      req_fd = *(++msg); 
      ++msg;
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      cur_fpset = fptr_list;
      
      while (cur_fpset && (cur_fpset->tid != clnt_taskid))
	cur_fpset = cur_fpset->next;
      
      if(!cur_fpset || (req_fd >= MAX_OPENFILES) || 
	 ((read_fd =cur_fpset->fd[req_fd] ) == 0)) {
	PDAP_fsrv_err(current_req, PDAP_BADF, " File not open");
	break;
      }
      if (close(read_fd) == -1) 
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
      else {
	cur_fpset->fd[req_fd] = 0;
	--cur_fpset->cnt;
	
	*rmsg = 1; ++rmsg;
	*rmsg = PDAP_SUCCESS;
	rpkt->length = 4;
	ardp_respond(current_req, ARDP_R_COMPLETE);
      }
      
      break;
      
      
    case PDAP_STAT:
      
      ++msg;
      *rmsg = (char)PDAP_STAT_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen);
      if (*msg != PDAP_FS) {
	PDAP_fsrv_err(current_req, PDAP_NAME_TYP, 
		      "Unsupported filename type");
	break;
      }       
      ++msg;
      
      bcopy(msg, fpath, nlen - 1);
      msg += nlen - 1;
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      if (stat(fpath, &statinfo) == -1) 
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
      else {
	pdap_datalen = sizeof(struct stat) + 1;
	ENCODE_ASN1_LENGTH(rmsg,pdap_datalen);
	*rmsg = PDAP_SUCCESS; ++rmsg;
	bcopy(&statinfo, rmsg, sizeof(struct stat)); 
	rpkt->length = rmsg + sizeof(struct stat) - rpkt->start;
	ardp_respond(current_req, ARDP_R_COMPLETE);
      }
      break;
      
    case PDAP_SEEK:
      
      ++msg;
      *rmsg = (char)PDAP_SEEK_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen);
      if(*msg != PDAP_HNDL_INT) {
	PDAP_fsrv_err(current_req, PDAP_HNDL_TYP, "Unsupported Handle Type");
	break;
      }
      req_fd = *(++msg); 
      ++msg;
      
      DECODE_ASN1_LENGTH(msg,offset);
      DECODE_ASN1_LENGTH(msg,whence);
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      clnt_taskid = ntohl(clnt_taskid);
      
      cur_fpset = fptr_list;
      while (cur_fpset && (cur_fpset->tid != clnt_taskid))
	cur_fpset = cur_fpset->next;
      
      if(!cur_fpset || (req_fd >= MAX_OPENFILES) || 
	 ((read_fd =cur_fpset->fd[req_fd] ) == 0)) {
	sprintf(p_err_string, "File not open", _progname);
	prm_server_respond(current_req, (u_char)FAILURE, (u_char)FAILURE,
			   0, p_err_string);
	break;
      }
      if (lseek(read_fd, offset, whence) == -1) {
	PDAP_fsrv_err(current_req, errno, sys_errlist[errno]);
      }
      else {
	*rmsg = 1; ++rmsg;
	*rmsg = PDAP_SUCCESS;
	rpkt->length = 4;
	ardp_respond(current_req, ARDP_R_COMPLETE);
      }
      
      break;
      
    case PDAP_DEL:
      
      ++msg;
      *rmsg = (char)PDAP_SEEK_RESP; ++rmsg;
      
      DECODE_ASN1_LENGTH(msg,nlen);
      if (*msg != PDAP_FS) {
	PDAP_fsrv_err(current_req, PDAP_NAME_TYP, 
		      "Unsupported filename type");
	break;
      }       
      ++msg;
      bcopy(msg, fname, nlen - 1);
      msg += nlen - 1;
      DECODE_ASN1_LENGTH(msg,clnt_taskid);
      
      if (unlink(fname) == -1) 
	PDAP_fsrv_err(current_req, errno, sys_errlist);
      else {
	*rmsg = 1; ++rmsg;
	*rmsg = PDAP_SUCCESS;
	rpkt->length = 4;
	ardp_respond(current_req, ARDP_R_COMPLETE);
      }
      
      break;
      
    default:
      break;
    }
  }
}

char *
get_bin_file(dname, fname)
char *dname, *fname;
{
  int pid, sp;
  char rpath[MAXPATHLEN+32];

  sprintf(rpath, "%s/%s", dname, fname);
  fprintf(stderr,"(%s) Copying file %s into %s ...\n", progname, rpath, 
		 locdir);

  if (vfork()) {
    wait(&sp);
    return( (WEXITSTATUS(sp) == 0)? locdir: (char *)0);
  }
  else {
    execl("/usr/ucb/rcp", "rcp", rpath, locdir, (char *)0 );

    fprintf(stderr, "(%s) Could not exec rcp\n", progname);
    _exit(-2);
  }
}




