/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 12/92
 *
 */

#include <prm-copyr.h>

#include <comm.h>

#ifdef DEBUG
#   ifdef HPUX
#      include <signal.h>
#   endif
#endif

vsend_v(dest_task_id, dest_port_id, tag, dataptr, elem_len, stride, elem_cnt)
int dest_task_id, tag;
u_char dest_port_id;
char *dataptr;
int elem_len, stride, elem_cnt;
{
  PTEXT pkt_0, pkt_i, prev_pkt;
  RREQ newreq;
  u_long ntmp1, i, byte_dist, data_len;
  int pkt_num, elems_per_pkt, npkts, reply_code;
  char *start, *from, *to;
  prm_node_addr_t dest_host_addr;
  extern prm_node_addr_t get_dest_addr();
  extern PTEXT gather_to_pkts();

  if (dest_task_id == _my_taskid) {
    strcpy(p_err_string, ": Cannot send message to myself.");
    return ERRORCODE;
  }
  
  /* Obtain the address of the host on which destination task is running.
     This could be from the local cache of the process, local nodemngr's 
     cache or the remote nodemngr's cache or the jobmngr */
  
  dest_host_addr = get_dest_addr(dest_task_id, dest_port_id);
  
  data_len = elem_len * elem_cnt;

  newreq = ardp_rqalloc();
  if( (newreq->outpkt = gather_to_pkts(dataptr, elem_len, stride, elem_cnt)) 
     == NOPKT) {
    strcpy(p_err_string, ": No data to send.");
    return ERRORCODE;
  }
  start = newreq->outpkt->start;
  prm_headers(newreq->outpkt, (u_char)PRM_APP_MSG, (u_char)0, (u_char)0, _my_jobid);
  ntmp1 = htonl(_my_taskid);
  bcopy(&ntmp1, start + PRM_TINFO_OFF, LONG_SZ);
  ntmp1 = htonl(data_len);
  bcopy(&ntmp1, start + PRM_DLEN_OFF, LONG_SZ);
  ntmp1 = htonl(tag);
  bcopy (&ntmp1, start + PRM_DATA_OFF, LONG_SZ);

  if ((perrno = ardp_send(newreq, 0, dest_host_addr, -1)) != ARDP_SUCCESS) {
    sprintf(p_err_string, ": ardp_send to %d returned %d", dest_task_id, 
	    perrno);
    return ERRORCODE;
  }

  if(newreq->rcvd)              /* reply recvd */
    reply_code = (int)*(newreq->rcvd->start + PRM_STATUS_OFF);
  else {
    reply_code = ERRORCODE;
    sprintf (p_err_string, ": Could not reach task %d", dest_task_id);
  }
  ardp_rqfree(newreq);
  return reply_code;
}



vrecv_v(sndr_task_id, rcv_port_id, tag, rcv_buffer, elem_len, stride, elem_cnt)
int sndr_task_id, tag;
u_char rcv_port_id;
char *rcv_buffer;
int elem_len, stride, elem_cnt;
{
  RREQ msgreq;
  PTEXT pkt_0, pkt_i, rpkt;
  int i, npkts, curlen; 
  u_long rcvd_len;
  u_long byte_dist, xpctd_len, copied_len ;
  int to_copy_len, cnt, nbytes;
  char *start, *from, *to;

  if (sndr_task_id == _my_taskid) {
    sprintf(p_err_string, ": Cannot receive message from myself.");
    return ERRORCODE;
  }

  msgreq = get_message(sndr_task_id, tag);
  pkt_0 = msgreq->rcvd;
  start = pkt_0->start;
  
  xpctd_len = elem_len * elem_cnt;

  if( *(start + PRM_OPCODE_OFF) != PRM_APP_MSG){
    strcpy(p_err_string, ": Illegal PRM opcode");
    return ERRORCODE;
  }
  if ( (elem_len == 0) || (elem_cnt == 0) || (rcv_buffer == NULL) )  
    copied_len = 0;
  else
    copied_len = scatter_from_pkts(pkt_0, rcv_buffer, elem_len, stride, 
				   elem_cnt);
  
  msgreq->outpkt = ardp_ptalloc();
  msgreq->outpkt->seq = 0;
  *(msgreq->outpkt->start + PRM_STATUS_OFF) = SUCCESS;
  msgreq->outpkt->length = PRM_STATUS_OFF + 1;
  ardp_respond(msgreq, ARDP_R_COMPLETE);             /*  Send reply to sender task  */  
}



vsendrecv(src_task_id,   src_tag, inbufp,   inlen, 
  dest_task_id, dest_tag, outbufp, outlen)

int src_task_id, src_tag, inlen, dest_task_id, dest_tag, outlen;
char *inbufp, *outbufp;
{
#define Dest_Port_Id 1
#define Src_Port_Id  1

  if (src_task_id < _my_taskid) {
    while (vsend (dest_task_id, Dest_Port_Id, dest_tag, outbufp, outlen)
	   != SUCCESS);
    vrecv (src_task_id, Src_Port_Id, src_tag, inbufp, inlen);
  }
  else {
    vrecv (src_task_id, Src_Port_Id, src_tag, inbufp, inlen);
    while(vsend (dest_task_id, Dest_Port_Id, dest_tag, outbufp, outlen)
	  == ERRORCODE)
      io_printf("vsend in vsendrecv%s", p_err_string, (char *)0);;   
  }
}


scatter_data(char *start, char *dest, int elem_len, int stride, int cnt)
{
  char *until_ptr; 
  char *from = start;
  char *to = dest;

  until_ptr = start + elem_len * cnt;
  while (from < until_ptr) {
    bcopy(from, to, elem_len);
    to += stride;
    from += elem_len;
  }
}


reduce_int(value, redn_op)
int value, redn_op;
{
  int ret_val;
  vsend(0, (u_char)1, redn_op, (char *)&value, sizeof(int));
  vrecv(0, (u_char)1, redn_op, (char *)&ret_val, sizeof(int));
  return ret_val;
}


PTEXT
  gather_to_pkts(char *dataptr, int elem_len, int stride, int elem_cnt)
{
  PTEXT firstpkt = NOPKT, pkt_i;
  char *from, *to;
  int max_elems_per_pkt, i;
  int nelems_last_pkt, tot_pkts, pkt_num;
  
  max_elems_per_pkt = PRM_APP_MSG_LEN/elem_len;
  nelems_last_pkt = elem_cnt % max_elems_per_pkt;
  tot_pkts = elem_cnt/max_elems_per_pkt + ( nelems_last_pkt > 0);
  
  from = dataptr;
  for (pkt_num = 1; pkt_num <= tot_pkts; pkt_num++ ) {
    int nelems_this_pkt = (((pkt_num == tot_pkts) && nelems_last_pkt) ?
			   nelems_last_pkt : max_elems_per_pkt);
    pkt_i = ardp_ptalloc();
    to = pkt_i->start + PRM_APPDT_OFF;
    for(i = 0; i < nelems_this_pkt; i++) {
      bcopy(from, to, elem_len);
      from += stride;  /* Note that stride is specified in bytes, 
			  not words */
      to += elem_len;
    }    
    pkt_i->length = PRM_APPDT_OFF + nelems_this_pkt * elem_len;
    APPEND_ITEM(pkt_i, firstpkt);
  }
  return firstpkt;
}


scatter_from_pkts(PTEXT pkt_list, char *rcv_buffer, int elem_len, int stride, 
		  int elem_cnt)
{
  PTEXT pkt_i;
  int i, max_elems_per_pkt, nelems_;
  u_long rcvd_len, nelems_remng, nelems_copied = 0;
  char *from, *to;

  bcopy (pkt_list->start + PRM_DLEN_OFF, &rcvd_len, LONG_SZ);
  rcvd_len = ntohl(rcvd_len);
  max_elems_per_pkt = PRM_APP_MSG_LEN/elem_len;
  nelems_remng = MIN(rcvd_len/elem_len, elem_cnt);
  
  pkt_i = pkt_list;

  to = rcv_buffer;
  while(pkt_i &&  (nelems_remng > 0)) {
    int nelems_this_pkt = MIN(nelems_remng,max_elems_per_pkt);
    from = pkt_i->start + PRM_APPDT_OFF;
    for(i = 0; i < nelems_this_pkt; i++) {
      bcopy(from, to, elem_len);
      from += elem_len;
      to += stride;
    }
    nelems_copied += nelems_this_pkt;
    nelems_remng -= nelems_this_pkt;

    pkt_i = pkt_i->next;
  }
  return (nelems_copied * elem_len);
}

#if 0
	scatter_data(pkt_i->start + PRM_APPL_MSG_OFFSET, rcv_buffer,
		     elem_len, stride, cnt);
	copied_len += elem_len * cnt;
	rcv_buffer += stride;
      }
      else {
	if (nbytes > 0) {
	  cnt = nbytes/elem_len;
	  scatter_data(pkt_i->start + PRM_APPL_MSG_OFFSET, rcv_buffer, 
		       elem_len, stride, cnt);
	  copied_len += nbytes;
	}
	break;
      }
      pkt_i = pkt_i->next;
    }
  }
}
#endif
