/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/92
 *
 */

#include <prm-copyr.h>

#include <stdio.h>
#include <comm.h>

/* vrecv - Receive a message matching the specified tag from the specifed task 
   on the specified port. If sndr_task_id == ANY_TASK, the sender_id is not 
   checked; only the tag is compared. If tag == ANY_TAG the tag field of the
   message, is not checked. buf points to the starting location where the 
   message is to be placed. xpctd_len is the expected length of the message. 
   If the length of the received message is larger than xpctd_len, only 
   xpctd_len bytes are copied in to buf. If the length of the received message
   is smaller, rcvd_len bytes are copied into buf. The return value is the
   actual number of bytes copied into buf.
*/

int
  vrecv(sndr_task_id, rcv_port_id, msg_tag, rcv_buffer, xpctd_len)
int sndr_task_id, msg_tag, xpctd_len;
u_char rcv_port_id;
char *rcv_buffer;
{
  RREQ msgreq;
  PTEXT pkt_list, rpkt;
  int copied_len, respval; 
  char *start, lfname[30];

  if (sndr_task_id == _my_taskid) {
    strcpy(p_err_string, ": Cannot receive message from myself!");
    return ERRORCODE;
  }
  
  /* Retrieve a message from sndr_task_id and tag matching msg_tag */
  msgreq = get_message(sndr_task_id, msg_tag);
  pkt_list = msgreq->rcvd;
  
  if( *(pkt_list->start + PRM_OPCODE_OFF) != PRM_APP_MSG) {
    strcpy(p_err_string, ": Illegal PRM opcode");
    return ERRORCODE;
  }
  if ( (xpctd_len == 0) || (rcv_buffer == NULL) )  
    copied_len = 0;
  else
    copied_len = extract_from_pkts(pkt_list, rcv_buffer, xpctd_len);
  
  /* Send acknowledge to sender task */  
  if ((respval = prm_server_respond(msgreq, (u_char)SUCCESS, (u_char)SUCCESS, 
				    0, (char *)0)) != ARDP_SUCCESS)
    io_printf("ardp_respond returned %d", respval, (char *)0);

  return copied_len;  /* length of the msg actually copied into rcv_buffer */
}

