/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 8/92
 *
 */

#include <prm-copyr.h>

#include <stdio.h>

#include <comm.h>


/* taskinit - gets parameters from command line and initializes variables. 
   Creates a communication port and binds a name to it. Currently, only one 
   port per task is supported, with a port_id of 1 */

init_task(av)
char **av;
{
  RREQ current_req;
  char buf[32], *b2;
  _progname = av[0];
  sscanf(av[1],"%lu", &_my_taskid); /* Get my task_id from command line */
  sscanf(av[2], "%lu", &_my_jobid);  /* Get my jobid from command line */
  b2 = (char *)malloc(strlen(_progname)+9);

#ifdef LOGPKTS
  sprintf(b2, "%s_%d.log", _progname, _my_taskid);
  set_logfile(b2);
#endif

  if ( _my_hostname == NULL ) {
    gethostname(_my_hostname, MAXHOSTNAMELEN);
  }

  /* create a port for communication and bind a name to it */
  sscanf(av[3], "%hu", &_my_portnum);
  if (_my_portnum <= 0) {
    if ( (_my_portnum = create_srv_socket(1, _my_taskid)) == 0) {
      fprintf(stderr, "%s (jid=%lu tid=%lu): %s\n", _progname, _my_jobid,
	      _my_taskid, p_err_string );
      exit(1);
    }
  }
  else {
    sprintf(buf,"#%d", _my_portnum);
    ardp_bind_port(buf);
  }
#ifdef DEBUG
  sleep(1);                /* To enable debuggers to attach to the process */
#endif

  do {
    current_req = ardp_get_nxt();
  } while( *(current_req->rcvd->start + PRM_OPCODE_OFF) != PRM_SYNC_TASKS);

  current_req->outpkt = ardp_ptalloc();
  prm_headers(current_req->outpkt, (u_char)PRM_TCREAT_RESP, (u_char)SUCCESS, 
	      0);
  current_req->outpkt->length = 3;
  ardp_respond(current_req, ARDP_R_COMPLETE);

  trsln_cache = (struct cache *)calloc(numtasks() + 1, sizeof(struct cache));
  bzero(trsln_cache, (_ntasks + 1) * sizeof(struct cache));

  initdone = TRUE;
}
