/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 3/93
 *
 */

#include <prm-copyr.h>


#ifndef PDAP_H_INCLUDED
#define PDAP_H_INCLUDED

/* Prospero Data Access Protocol */

#define PDAP_VERSION 1

/* PDAP Operations */

#define PDAP_NO_OP       0
#define PDAP_OPEN        1
#define PDAP_OPEN_RESP   2
#define PDAP_CLOSE       3
#define PDAP_CLOSE_RESP  4
#define PDAP_STAT        5
#define PDAP_STAT_RESP   6
#define PDAP_READ        7
#define PDAP_READ_RESP   8
#define PDAP_WRITE       9
#define PDAP_WRITE_RESP 10
#define PDAP_SEEK       11
#define PDAP_SEEK_RESP  12
#define PDAP_FILE_XFER  13
#define PDAP_FXFER_RESP 14

#define PDAP_DEL        21
#define PDAP_DEL_RESP   22

#define PDAP_LEASE_REQ  31
#define PDAP_LEASE_RESP 32

#define PDAP_AUTH       51
#define PDAP_AUTH_RESP  52

/* File handle types */

#define PDAP_HNDL_INT    1   /* An integer index into the file_iotask 
				maintained array of file descriptors */

#define PDAP_SUCCESS     0
#define PDAP_FAILURE     1
#define PDAP_WARNING     2

#define PDAP_DATA_PKT_SZ    1024  /* Data is broken into 1K pkts */


/* PDAP Error codes */

#define PDAP_NO_SRVR        101
#define PDAP_WRONG_VERSION  102
#define PDAP_WRONG_RESP     103
#define PDAP_HNDL_TYP       104
#define PDAP_BADF           105
#define PDAP_STAT_ERR       106
#define PDAP_NAME_TYP       107  /* Unsupported filename type */
#define PDAP_TOO_MANY       108  /* Too many open files */  
#define PDAP_ARDP_ERR       109
#define PDAP_UNKNOWN        110

/* file name types for open */

#define PDAP_FS    1


#define DECODE_ASN1_LENGTH(c,length)                                      \
    do { int l = (*c & 0x7f);                                             \
    if (*c & 0x80) {  length = 0;                                         \
      while (l) {  ++c; length = (length << 8) + (u_char)*c;--l; } }      \
    else length = (u_long)l;                                              \
    ++c; } while(0)


#define ENCODE_ASN1_LENGTH(c,length)                                      \
  do { int  l=3;                                                          \
    if ((length) > 127) { while ( !((length) & (0xff << (l << 3)))) --l;  \
      *c = (char)(0x80 | (++l));                                          \
      while(l) { *(++c) = (char)( ((length) >> ((--l) <<3))); } }         \
    else *c = (char)(length);	                                          \
    ++c; } while(0)
				    

#define N_OCTETS(len,n)   do { u_long l=0xff000000; n=5; \
		 if (len < 128) n=1; else if (len < 256) n = 2; \
	else while(n && !((len) & l)) {l = (l >> 8); --n; }} while(0)


/* Caching responses */

#define COPY_CRNT 1  /* copy is upto date */
#define COPY_OOD  2  /* copy is out of date */

#endif  /*  PDAP_H_INCLUDED */
