/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 1/93
 *
 */

#include <prm-copyr.h>
#include <comm.h>

#if defined(HPUX)

#   include <math.h>

#   include <sys/time.h>
#   include <sys/resource.h>
#   include <errno.h>

#   include <unistd.h>   
#   include <sys/times.h>

    extern char *sys_errlist[];

    static long ticks_per_sec=0;

    hp_getrusage(int who, struct rusage *usage)
    {
      struct tms cpu_times;
      
      if (!usage) {
	errno = EFAULT;
	return -1;
      }
      if (!ticks_per_sec) {
	ticks_per_sec = sysconf(_SC_CLK_TCK);
      }
      if ( times(&cpu_times) == -1) {
	return -1;
      }
      if (who == RUSAGE_SELF) {
	usage->ru_utime.tv_sec = cpu_times.tms_utime / ticks_per_sec;	
	usage->ru_utime.tv_usec =cpu_times.tms_utime * 1000000 / ticks_per_sec;
	usage->ru_stime.tv_sec = cpu_times.tms_stime / ticks_per_sec;	
	usage->ru_stime.tv_usec =cpu_times.tms_stime * 1000000 / ticks_per_sec;
	
      }
      if (who == RUSAGE_CHILDREN) {
	usage->ru_utime.tv_sec = cpu_times.tms_cutime / ticks_per_sec;	
	usage->ru_utime.tv_usec=cpu_times.tms_cutime * 1000000 / ticks_per_sec;
	usage->ru_stime.tv_sec = cpu_times.tms_cstime / ticks_per_sec;	
	usage->ru_stime.tv_usec=cpu_times.tms_cstime * 1000000 / ticks_per_sec;
	
      }
      else {
	errno = EINVAL;
	return -1;
      }
      return 0;
    }

#endif 

