/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 1/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>

#if defined(HPUX)
#   include <unistd.h>   
#endif


PTEXT
copy_to_pkts(char *dataptr, int tot_len)
{

  PTEXT firstpkt = NOPKT, pkt_i;
  char *start;
  int last_pdata_len, tot_pkts, pkt_num;

  last_pdata_len = tot_len % PRM_APP_MSG_LEN ;
  tot_pkts = tot_len/PRM_APP_MSG_LEN + (last_pdata_len > 0);
  
  for (pkt_num = 1; pkt_num <= tot_pkts; pkt_num++) {
    int this_pkt_dat_len = (((pkt_num == tot_pkts) && last_pdata_len) ? 
			    last_pdata_len : PRM_APP_MSG_LEN );
    pkt_i = ardp_ptalloc();
    bcopy(dataptr, pkt_i->start + PRM_APPDT_OFF, this_pkt_dat_len);
    dataptr += PRM_APP_MSG_LEN;
    pkt_i->length = PRM_APPDT_OFF + this_pkt_dat_len;
    APPEND_ITEM(pkt_i, firstpkt);
  }
  return firstpkt;
}


extract_from_pkts(PTEXT pkt_list, char *rcv_buffer, int xpctd_len)
{
  PTEXT pkt_i;
  int len;
  u_long rcvd_len, bytes_remng, copied_len = 0;
  
  bcopy (pkt_list->start + PRM_DLEN_OFF, &rcvd_len, LONG_SZ);
  rcvd_len = ntohl(rcvd_len);
  bytes_remng = MIN(rcvd_len, xpctd_len);
  
  pkt_i = pkt_list;
  
  while(pkt_i && (bytes_remng > 0) ) {
    len = MIN(bytes_remng,PRM_APP_MSG_LEN); 
    bcopy(pkt_i->start + PRM_APPDT_OFF, rcv_buffer, len);
    copied_len += len;
    rcv_buffer += len;
    bytes_remng -= len;

    pkt_i = pkt_i->next;
  }
  return copied_len;
}

